from defence360agent.contracts.config import IConfig, LocalConfig


def migrate(
    migrator,
    database,
    fake=False,
    config_file: IConfig = LocalConfig(),
    **kwargs
):
    if fake:
        return

    conf = config_file.config_to_dict()
    if not conf:
        return

    mod_sec_settings = conf.setdefault("MOD_SEC", {})
    mod_sec_settings.pop("was_installed", None)
    mod_sec_settings.pop("OWASP_deleted", None)

    config_file.dict_to_config(conf, validate=False, overwrite=True)


def rollback(migrator, database, fake=False, **kwargs):
    pass
