import logging
import os

from defence360agent.contracts.config import LocalConfig

logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    if fake:
        return

    local_config = LocalConfig()
    if not os.path.exists(local_config.path):
        return
    config = local_config.config_to_dict()

    if "CSF_COOPERATION" in config:
        config.pop("CSF_COOPERATION")
        local_config.dict_to_config(config, overwrite=True, validate=False)


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
