"""
Fix IPs that were added with NULL expiration to the WB lists
"""


def migrate(migrator, database, fake=False, **kwargs):
    IPListModel = migrator.orm["iplist"]
    IPListModel.update(expiration=0).where(
        (IPListModel.listname.in_(["WHITE", "BLACK"]))
        & (IPListModel.expiration.is_null())
    ).execute()


def rollback(migrator, database, fake=False, **kwargs):
    pass
