import logging


logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    """
    This migration os only for consistency, actually all works
    with CharField as well
    """

    migrator.sql(
        """
        CREATE TABLE "malware_hits_new" (
            "id" INTEGER NOT NULL PRIMARY KEY,
            "scanid_id" VARCHAR(255) NOT NULL,
            "user" VARCHAR(255) NOT NULL,
            "orig_file" BLOB NOT NULL,
            "type" VARCHAR(255) NOT NULL,
            "restored" INTEGER NOT NULL,
            "mode" INTEGER,
            "vendor" VARCHAR(255) NOT NULL,
            "malicious" INTEGER NOT NULL,
            FOREIGN KEY ("scanid_id") REFERENCES "malware_scans" ("scanid"))
    """
    )
    migrator.sql("INSERT INTO malware_hits_new SELECT * FROM malware_hits")
    migrator.sql("DROP TABLE malware_hits")
    migrator.sql("ALTER TABLE malware_hits_new RENAME TO malware_hits")


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
