from defence360agent.contracts.config import ConfigFile, IConfig


def migrate(*_, fake=False, config_file: IConfig = ConfigFile(), **__):
    if fake:
        return
    if not (config := config_file.config_to_dict()):
        return
    malware_settings = config.get("MALWARE_SCANNING", {})
    malware_settings.pop("leave_suspicious", None)
    malware_settings.pop("max_days_in_quarantine", None)
    malware_settings.pop("move_to_quarantine", False)

    config_file.dict_to_config(config, overwrite=True, validate=False)


def rollback(*_, **__):
    pass
