import logging


logger = logging.getLogger(__name__)

DATA = [
    (
        "Google (https://support.google.com/webmasters/answer/80553?hl=ru)",  # noqa
        [".google.com", ".googlebot.com"],
    ),
    (
        (  # noqa
            "Yandex"
            " (https://yandex.ru/support/webmaster/robot-workings/check-yandex-robots.xml?lang=ru)"  # NOQA E501
        ),
        [".yandex.ru", ".yandex.com", ".yandex.net"],
    ),
    (
        (  # noqa
            "Bing (https://www.bing.com/webmaster/help/how-to-verify-bingbot-3905dc26)"  # NOQA E501
        ),
        [".search.msn.com"],
    ),
    (
        (  # noqa
            "Baidu"
            " (http://help.baidu.com/question?prod_en=master&class=Baiduspider)"
        ),
        [".baidu.com", ".baidu.jp"],
    ),
]


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""
    if fake:
        return

    wc = migrator.orm["whitelisted_crawlers"]
    wcd = migrator.orm["whitelisted_crawler_domains"]

    with database.atomic():
        for descr, domains in DATA:
            inserted_id = wc.insert(description=descr).execute()
            for d in domains:
                wcd.insert(crawler=inserted_id, domain=d).execute()


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
