"""
Introducing new filed `auto_whitelisted` in order to mark IPs that were
autowhitelied during `--remote-addr` flag.
This will help to differentiate such IPs in UI.
"""
import peewee as pw


def migrate(migrator, database, fake=False, **kwargs):
    IPList = migrator.orm["iplist"]
    migrator.add_fields(
        IPList, auto_whitelisted=pw.BooleanField(default=False, null=True)
    )


def rollback(migrator, database, fake=False, **kwargs):
    IPList = migrator.orm["iplist"]
    migrator.remove_fields(IPList, "auto_whitelisted")
