import logging


logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    migrator.sql(
        """
        CREATE TABLE "malware_hit_extras_new" (
          "id" INTEGER NOT NULL PRIMARY KEY,
          "hit_id" INTEGER NOT NULL,
          "name" VARCHAR(255) NOT NULL,
          "value" VARCHAR(255) NOT NULL,
          FOREIGN KEY ("hit_id")
            REFERENCES "malware_hits" ("id") ON DELETE CASCADE
        )
    """
    )
    migrator.sql(
        "INSERT INTO malware_hit_extras_new SELECT * FROM malware_hit_extras"
    )
    migrator.sql("DROP TABLE malware_hit_extras")
    migrator.sql(
        "ALTER TABLE malware_hit_extras_new RENAME TO malware_hit_extras"
    )


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
