import logging


logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    migrator.sql(
        """
        CREATE TABLE "malware_hits_new" (
            "id" INTEGER NOT NULL PRIMARY KEY,
            "scanid_id" VARCHAR(255) NOT NULL,
            "user" VARCHAR(255) NOT NULL,
            "orig_file" VARCHAR(255) NOT NULL,
            "type" VARCHAR(255) NOT NULL,
            "restored" INTEGER NOT NULL,
            "mode" INTEGER,
            FOREIGN KEY ("scanid_id") REFERENCES "malware_scans" ("scanid"))
    """
    )
    migrator.sql("INSERT INTO malware_hits_new SELECT * FROM malware_hits")
    migrator.sql("DROP TABLE malware_hits")
    migrator.sql("ALTER TABLE malware_hits_new RENAME TO malware_hits")


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
