import logging

from defence360agent.contracts.config import IConfig, LocalConfig

logger = logging.getLogger(__name__)


def migrate(
    migrator,
    database,
    fake=False,
    config_file: IConfig = LocalConfig(),
    **kwargs
):
    """Write your migrations here."""

    if fake:
        return

    config = config_file.config_to_dict()
    if not config:
        return
    # deleting "OSSEC" section
    config.pop("OSSEC", {})

    # deleting "MOD_SEC_BLOCK_BY_SEVERITY:ignore" field
    config.get("MOD_SEC_BLOCK_BY_SEVERITY", {}).pop("ignore", [])

    config_file.dict_to_config(config, overwrite=True, validate=False)


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    pass
