import logging

import peewee as pw


logger = logging.getLogger(__name__)


def migrate(migrator, database, fake=False, **kwargs):
    """Write your migrations here."""

    MalwareHit = migrator.orm["malware_hits"]

    class MalwareHitExtra(pw.Model):
        class Meta:
            db_table = "malware_hit_extras"

        id = pw.IntegerField(primary_key=True)
        hit = pw.ForeignKeyField(MalwareHit, null=False, related_name="extras")
        name = pw.CharField(null=False)
        value = pw.CharField(null=False)

    migrator.create_model(MalwareHitExtra)


def rollback(migrator, database, fake=False, **kwargs):
    """Write your rollback migrations here."""
    MalwareHitExtra = migrator.orm["malware_hit_extras"]
    migrator.remove_model(MalwareHitExtra)
