import os
import subprocess

from defence360agent.contracts.config import Packaging
from logging import getLogger

logger = getLogger(__name__)


def disable_3rdparty():
    try:
        subprocess.check_call(
            [
                "%s/scripts/disable_3rd_party_ids" % Packaging.DATADIR,
                "--nocheck",
            ]
        )
    except subprocess.CalledProcessError as e:
        logger.error(e)


def migrate(migrator, database, fake=False, **kwargs):
    if fake or not os.path.isfile(Packaging.DATADIR):
        return

    disable_3rdparty()


def rollback(migrator, database, fake=False, **kwargs):
    pass
