from peewee import IntegrityError, Model as BaseModel


class Model(BaseModel):
    """
    Common Model class that fix create_or_get method with using CompositeKey.
    https://stackoverflow.com/questions/35167628/peewee-create-or-get-error-in-model-with-compositekey
    """

    @classmethod
    def create_or_get(cls, **kwargs):
        try:
            with cls._meta.database.atomic():
                return cls.create(**kwargs), True
        except IntegrityError:
            query = []
            for field_name, value in kwargs.items():
                field = getattr(cls, field_name)
                field_is_primary_key = (
                    field.name in cls._meta.primary_key.field_names
                    if cls._meta.composite_key
                    else field.primary_key
                )
                if field.unique or field_is_primary_key:
                    query.append(field == value)
            return cls.get(*query), False
