from defence360agent.contracts import config


class RpcError(RuntimeError):
    pass


class ResponseError(RpcError):
    pass


class SocketError(RpcError):
    pass


class ServiceStateError(SocketError):
    def __init__(self, state="stopped"):
        super().__init__(
            "{} service is {}.".format(config.Core.PRODUCT, state)
        )


class NonRootValidationError(RpcError):
    pass
