# feature name constants

PROACTIVE = "proactive"
AV = "av"

#: Not available permissions
NA = "na"
#: Full permissions
FULL = "full"

#: Report only permission for AV feature
AV_REPORT = "report"

# config sections related to feature
CONFIG_MAPPINGS = {
    PROACTIVE: {
        "PROACTIVE_DEFENCE": [FULL],
    },
}

# Native FM panel extension name
NATIVE_EXTENSION_NAME = "imunify360"

# Mapping of feature names to extension variables
FEATURE_EXT_VARIABLES = {
    AV: "imunify360_av",
    PROACTIVE: "imunify360_proactive",
}
# Mapping of extension variable to default value
EXTENSION_DEFAULTS = {
    FEATURE_EXT_VARIABLES[AV]: AV_REPORT,
    FEATURE_EXT_VARIABLES[PROACTIVE]: FULL,
}

NATIVE_FEATURE_MANAGEMENT_PACKAGE_EXTENSION_FILES = (
    NATIVE_EXTENSION_NAME,
    NATIVE_EXTENSION_NAME + ".tt2",
)
