"""
This package contains the definitions for cleaners. A cleaner can be
used to delete old files, database entries, etc.

All cleaners:

- inherit from BaseCleaner (implement the interface)

- should be used in the MrProper plugin to have any effect
"""
from abc import ABC, abstractmethod


class BaseCleaner(ABC):
    @property
    @classmethod
    @abstractmethod
    def PERIOD(cls):
        pass

    @classmethod
    @abstractmethod
    async def cleanup(cls):
        pass
