# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
"""Initial alembic

Revision ID: 48efb1674139
Revises:
Create Date: 2016-07-22 12:15:29.675430

"""

from alembic import op
from sqlalchemy import Integer, Float, String
from sqlalchemy import Column, UniqueConstraint
from sqlalchemy.engine.reflection import Inspector

# revision identifiers, used by Alembic.
revision = '48efb1674139'
down_revision = None
branch_labels = None
depends_on = None

SERVER_ID_LENGTH = 255
HISTORY_X60_TABLE_NAME = 'lve_stats2_history_x60'

history_x60_items = (
    Column('id', Integer, primary_key=True, autoincrement=False),
    Column('time', Integer),
    Column('cpu', Float),
    Column('cpu_limit', Integer),
    Column('cpu_fault', Integer),
    Column('mep', Integer),
    Column('mep_limit', Integer),
    Column('io', Float),
    Column('io_limit', Integer),
    Column('io_fault', Integer),
    Column('mem', Float),
    Column('mem_limit', Integer),
    Column('mem_fault', Integer),
    Column('mep_fault', Integer),
    Column('created', Integer, index=True, primary_key=True,
           autoincrement=False),
    Column('server_id', String(SERVER_ID_LENGTH), primary_key=True,
           autoincrement=False),
    Column('lmemphy', Integer),
    Column('memphy', Float),
    Column('memphy_fault', Integer),
    Column('lnproc', Integer),
    Column('nproc', Integer),
    Column('nproc_fault', Integer),
    Column('liops', Integer),
    Column('iops', Integer),
    Column('iops_fault', Integer),
    UniqueConstraint('server_id', 'id', 'created', name='primary_key'))


def upgrade():
    """
    for support upgrade from lve-stats-2.1-8
    :return:
    """
    connection = op.get_bind()
    inspector = Inspector.from_engine(connection)
    # create table history_x60 if not exist
    if HISTORY_X60_TABLE_NAME not in inspector.get_table_names():
        op.create_table(HISTORY_X60_TABLE_NAME, *history_x60_items)


def downgrade():
    pass
