#!/usr/bin/env python
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

import os
import glob


def plugins_trash_cleaner(plugins_dir='/usr/share/lve-stats/plugins/'):
    py_mask = os.path.join(plugins_dir, '*.py')
    pyc_mask = py_mask + 'c'

    # clear broken links to py files
    for py_ in glob.glob(py_mask):
        if os.path.islink(py_) and not os.path.exists(os.path.realpath(py_)):
            os.unlink(py_)

    # clear compiled plugins trash
    for pyc_ in glob.glob(pyc_mask):
        if not os.path.exists(pyc_[:-1]):
            os.unlink(pyc_)


if __name__ == '__main__':
    plugins_trash_cleaner()
