<?php
/**
 * Coppermine Photo Gallery
 *
 * v1.0 originally written by Gregory Demar
 *
 * @copyright  Copyright (c) 2003-2021 Coppermine Dev Team
 * @license    GNU General Public License version 3 or later; see LICENSE
 *
 * keyword_create_dict.php
 * @since  1.6.10
 */

define('IN_COPPERMINE', true);
define('EDITPICS_PHP', true);

require 'include/init.inc.php';

if (!GALLERY_ADMIN_MODE) {
    cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
}

$output = ($CPG_REFERER != 'keyword_select.php');
if ($output) { pageheader_mini($lang_gallery_admin_menu['key_lnk']); }

$query = "SELECT keywords FROM {$CONFIG['TABLE_PICTURES']} WHERE keywords <> ''";
$result = cpg_db_query($query);
$i = 0;
if ($result->numRows()) {

    if ($output) { starttable('100%', $lang_gallery_admin_menu['key_lnk']); }

    cpg_db_query("TRUNCATE TABLE {$CONFIG['TABLE_DICT']}");
    while ($row = $result->fetchAssoc()) {
        $keyArr = explode($CONFIG['keyword_separator'], html_entity_decode($row['keywords']));
        foreach ($keyArr as $keyword) {
            $keyword = trim($keyword);
            if (empty($keyword)) {
                continue;
            }
            $query = "SELECT null FROM {$CONFIG['TABLE_DICT']} WHERE keyword = '$keyword'";
            $result2 = cpg_db_query($query);
            if (!$result2->numRows(true)) {
                $query = "INSERT INTO {$CONFIG['TABLE_DICT']} (keyword) VALUES ('$keyword')";
                cpg_db_query($query);
                if ($output) { echo '<tr><td class="tableh2">' . $keyword . '</td></tr>'; }
                $i++ ;
            }
        }
    }
    if ($output) { endtable(); }
}
$result->free();

if ($output) {
    echo "<p>{$lang_editpics_php['new_keywords']}: $i</p>";
    pagefooter_mini();
} else {
    header("Location: $CPG_REFERER");
}

//EOF