# -*- coding: utf-8 -*-

"""
api that is suitable for both cPanel, Directadmin, interWorx
"""

import socket

from clcommon import mysql_lib


def get_cp_description():
    """
    Retrieve panel name and it's version
    :return: dict: { 'CPName': 'panel_name', 'CPVer': 'panel_version', 'CPAdd': 'add_info'}
        or None if can't get info
    """
    return None


def _dblogin_cplogin_pairs(access, cplogin_lst=None, dbname='mysql'):
    """
    Extracting database login control panel login pairs from mysql database
    supported for cPanel, interWorx, Directadmin
    :param dblogin:
    :param dbpass:
    :param dbhost:
    :param dbname:
    :param cplogin_lst:
    :return:
    """
    dbhost = access.get('host', 'localhost')
    dblogin = access['login']
    dbpass = access['pass']

    sql = r"SELECT User, LEFT(Db, LOCATE('\\', Db) - 1) FROM db WHERE User != '' and Db LIKE '%\\\%'"
    if cplogin_lst:
        joined_cplogin_lst = "', '".join(cplogin_lst)
        sql += rf" and LEFT(Db, LOCATE('\\', Db) - 1) in ('{joined_cplogin_lst}')"
    sql += r" GROUP BY User"

    connector = mysql_lib.MySQLConnector(host=dbhost, user=dblogin,
                                         passwd=dbpass, db=dbname)
    with connector.connect() as db:
        return db.execute_query(sql)


def get_admin_email(_hostname=None):
    """
    Gets admin email
    :param str|None _hostname: hostname for testing
    :return: admin's email
    :rtype: string
    """
    return 'root@' + (_hostname or socket.gethostname())


def admins(debug=False):
    """
    List all admins names in given control panel
    :param bool debug: Do produce debug output or don't
    :return: list of strings
    """
    return ["root"]


def is_admin(username):
    """
    Return True if username is in admin names
    :param str username: user to check
    :return: bool
    """
    return username in admins()
