# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from typing_extensions import TypedDict

from clcommon.cpapi.cpapiexceptions import (
    CPAPIException,
    NotSupported,
    NoDBAccessData,
    NoPackage,
    NoPanelPackage,
    NoPanelUser,
    NoDomain
)

from .general_panel import GeneralPanelPluginV1, CPAPI_CACHE_STORAGE


class PHPDescription(TypedDict):
    """
    Structure used in generic api calls returning
    list of php's supported by control panel.
    """

    # e.g. alt-php72
    identifier: str

    # e.g. '5.6'
    version: str

    # e.g. '/opt/alt/php51/usr/lib64/php/modules/'
    modules_dir: str

    # e.g. '/opt/alt/php80/usr/bin/php'
    bin: str

    # e.g. '/opt/alt/php51/etc/php.ini'
    ini: str

    # e.g. '/opt/alt/php51/'
    dir: str


class DomainDescription(TypedDict):
    """
    Used to describe domain relation to user and php
    """
    # e.g. user1
    username: str

    # e.g. alt-php72
    php_version_id: str

    # e.g. php-fpm
    handler_type: str

    # e.g. alt-php72
    display_version: str


__all__ = [
    "GeneralPanelPluginV1",
    "CPAPIException",
    "NotSupported",
    "NoDBAccessData",
    "NoPackage",
    "NoPanelPackage",
    "NoPanelUser",
    "NoDomain",
    "PHPDescription",
    "DomainDescription",
    "CPAPI_CACHE_STORAGE"
]
