# -*- coding: utf-8 -*-

from clcommon.cpapi.cpapiexceptions import NotSupported
from clcommon.cpapi.const import UNKNOWN_CP_NAME
from clcommon.features import Feature
from clcommon.cpapi.GeneralPanel import GeneralPanelPluginV1

__cpname__ = UNKNOWN_CP_NAME


def get_cp_description():
    """
    Retrieve panel name and it's version
    :return: dict: { 'CPName': 'panel_name', 'CPVer': 'panel_version', 'CPAdd': 'add_info'}
        or None if can't get info
    """
    return None


def db_access():
    raise NotSupported('Unable to receive data. Not supported without a control panel')


def cpusers():
    """
    return all users list registered on Control Panel
    :return: tuple registered users
    """
    raise NotSupported({
        'message': '%(action)s is not currently supported.',
        'context': {'action': 'Getting all users registered in the control panel'}
    })


def dblogin_cplogin_pairs(cplogin_lst=None, with_system_users=False):
    raise NotSupported('Unable to receive data. Not supported without a control panel')


def get_admin_email(_hostname=None):
    """
    Gets admin email
    :param str|None _hostname: for testing
    :return: admin's email
    :rtype: string
    """
    from clcommon.cpapi.plugins.universal import get_admin_email  # pylint: disable=import-outside-toplevel
    return get_admin_email(_hostname=_hostname)


class PanelPlugin(GeneralPanelPluginV1):
    def __init__(self):
        super().__init__()

    def getCPName(self):
        """
        Return panel name
        :return:
        """
        return __cpname__

    def get_cp_description(self):
        """
        Retrieve panel name and it's version
        :return: dict: { 'CPName': 'panel_name', 'CPVer': 'panel_version', 'CPAdd': 'add_info'}
            or None if can't get info
        """
        return None

    def get_admin_email(self):
        """
        Retrieve admin email address
        :return: Host admin's email
        """
        return get_admin_email()

    def db_access(self):
        raise NotSupported('Unable to receive data. Not supported without a control panel')

    def cpusers(self):
        """
        return all users list registered on Control Panel
        :return: tuple registered users
        """
        raise NotSupported({
            'message': '%(action)s is not currently supported.',
            'context': {'action': 'Getting all users registered in the control panel'}
        })

    def dblogin_cplogin_pairs(self, cplogin_lst=None, with_system_users=False):
        raise NotSupported('Unable to receive data. Not supported without a control panel')

    def admin_packages(self, raise_exc=False):
        """
        Return list of available admin's packages
        :return: List of packages. For example
            ['BusinessPackage', 'Package2']
        """
        return []

    def reseller_package_by_uid(self, user_id):
        """
        Retrieves reseller name and package name by uid
        :param user_id: User id
        :return: Cortege: (Reseller_name, Package_name)
        """
        return ()

    def get_uids_list_by_package(self, package_name, reseller_name=None):
        """
        Retrieves uid list for package
        :param package_name: Package name
        :param reseller_name: Reseller name. None for admin's package
        :return: List of uids
            Example: ['1000', '1002', '1006', '1007', '1008']
        """
        return []

    def cpinfo(self, cpuser=None, keyls=('cplogin', 'package', 'mail', 'reseller', 'dns', 'locale'),
               search_sys_users=True):
        """
        Retrives specified info about panel users
        :param str|unicode|list|tuple|None cpuser: user login
        :param keyls: List or cortege of data which is necessary to obtain the user,
                    values can be:
           cplogin - name/login user control panel
           mail - Email users
           reseller - name reseller/owner users
           locale - localization of the user account
           package - User name of the package
           dns - domain of the user
           userid - uid
        :param search_sys_users:
        :return: returns a tuple of tuples of data in the same sequence as specified keys in keylst
            Examples:
            cpinfo('cltest1')
                (('cltest1', 'default', '', 'root', 'cltest1.com', 'en'),)
            cpinfo()
                (('res1usr1', 'res1_pack1', '', 'res1', 'res1usr1.com', 'en'),
                 ('res1', 'default', '', 'root', 'res1.com', 'en'),
                 ('res2', 'default', '', 'res2', 'res2.com', 'en'),
                 ('cltest1', 'default', '', 'root', 'cltest1.com', 'en'),
                 ('system', 'undefined', None, 'root', '', 'en'))
        :rtype: tuple
        """
        return ()

    def resellers_packages(self, raise_exc=False):
        """
        Return dictionary, contains available resellers packages, grouped by resellers
        :return: Dictionary.
            Example:
            {'res1': ['BusinessPackage', 'UltraPackage', 'Package'],
             'res2': ['SimplePackage', 'Package'] }
        """
        return {}

    def get_admin_emails_list(self):
        """
        Gets admin emails list
        :rtype: List
        :return: List: ['admin1@mail.com', 'admin2@mail.com' ]
        """
        return []

    def docroot(self, domain):
        """
        Return document root for domain
        :return: Cortege: (document_root, owner)
        """
        return "", ""

    @staticmethod
    def useraliases(cpuser, domain):
        """
        Return aliases from user domain
        :param str|unicode cpuser: user login
        :param str|unicode domain:
        :return list of aliases
        """
        return []

    def userdomains(self, cpuser):
        """
        Return domain and document root pairs for control panel user
        first domain is main domain
        :param str|unicode cpuser: user login
        :rtype: List
        :return: list of tuples (domain_name, documen_root)
        """
        return []

    def homedirs(self):
        """
        Detects and returns list of folders contained the home dirs of users of the cPanel
        :rtype: List
        :return: list of folders, which are parent of home dirs of users of the panel
        """
        return []

    def reseller_users(self, resellername=None):
        """
        Return reseller users
        :param resellername: reseller name; autodetect name if None
        :rtype: List
        :return list[str]: user names list
        """
        return []

    def reseller_domains(self, resellername=None):
        """
        Return reseller users and their main domains
        :param resellername: reseller name; autodetect name if None
        :return dict[str, str]: pairs user <==> domain
        """
        return {}

    def get_user_login_url(self, domain):
        """
        Get login url for current panel;
        :type domain: str
        :rtype: str
        :return: Panel login URL
        """
        return ""

    def get_reseller_id_pairs(self):
        """
        Get dict reseller => id
        Optional method for panels without hard
        link reseller <=> system user
        :rtype: dict[str,int] - {'res1': id1}
        :return:
        """
        return {}

    def get_unsupported_cl_features(self) -> tuple[Feature, ...]:
        """
        Return list of cloudlinux features that can be used
        on current control panel.
        """
        return (
            # PHP_SELECTOR can work without web-panel, other selectors can't
            # because they need actual info from cpapi functions like userdomains, not empty lists
            Feature.RUBY_SELECTOR,
            Feature.PYTHON_SELECTOR,
            Feature.NODEJS_SELECTOR,
            Feature.RESELLER_LIMITS,
            Feature.WPOS,
        )
