# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

import os
import subprocess
import sys

# Exit code when LVE doesn't support reseller limits
TOO_OLD_LVE = 38

EXIT_NO_USER_FOUND = 1
ERR_NO_USER_FOUND = 'Unable to find username in hook cmdline'

LVECTL = '/usr/sbin/lvectl'
WHMAPI1 = '/usr/sbin/whmapi1'

LVE_DIR = '/var/lve'
TMP_DIR = os.path.join(LVE_DIR, 'tmp')


def syncmap_supported():
    test_cmd = rf"{LVECTL} --help | grep -P '^sync-map\s+' &> /dev/null"
    return not subprocess.call(test_cmd, shell=True, executable='/bin/bash')


# still used in lve-utils several times
# move it there and then remove this file completely
def call_sync_map():
    """
    Run lvectl sync-map
    :return: None
    """
    ret_code = subprocess.call(f'{LVECTL} sync-map &> /dev/null',
                               shell=True, executable='/bin/bash')
    if ret_code not in (0, TOO_OLD_LVE):    # ignore calls with unsupported LVE
        if syncmap_supported():  # ignore only no such command "sync-map" error
            print(f'Error during "lvectl sync-map", code: {ret_code}', file=sys.stderr)
