import sys
from functools import wraps
from clcommon.const import Feature
from clcommon.cpapi import is_panel_feature_supported

from clcommon.lib.cledition import (
    CLEditionDetectionError,
)

__all__ = (
    "skip_without_lve",
    "lve_supported_or_exit",
)


_SKIP_MESSAGE = (
    "Command is skipped as LVE feature is not supported in current environment\n"
    "Refer to https://docs.cloudlinux.com/solo/introduction/#cloudlinux-os-editions-comparison for more info"
)


def skip_without_lve():
    try:
        # we still have some utils that could be run
        # under user (e.g cloudlinux-selector)
        if not is_panel_feature_supported(Feature.LVE):
            print(_SKIP_MESSAGE)
            sys.exit(0)
    except CLEditionDetectionError as e:
        print(f"Error: {e}")
        sys.exit(1)


def lve_supported_or_exit(f):
    @wraps(f)
    def inner(*args, **kwargs):
        if not is_panel_feature_supported(Feature.LVE):
            print(_SKIP_MESSAGE)
        else:
            return f(*args, **kwargs)

    return inner
