# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

__author__ = 'schernikov'

import cProfile
import pstats


def profile(func):
    def wrapper(*args, **kwargs):
        prof = cProfile.Profile()
        retval = prof.runcall(func, *args, **kwargs)
        stats = pstats.Stats(prof)
        stats.sort_stats('tottime')
        print("STATS" + "=" * 50)
        stats.print_stats(25)
        return retval

    return wrapper

