<?php
$lang['description'] = 'Этот модуль обеспечивает простой и легкий способ для генерации HTML, необходимого для вывода меню. Он обеспечивает гибкие и широкие возможности создавать мощные, быстрые и привлекательные меню на веб-сайте без взаимодействия с редактором контента.';
$lang['friendlyname'] = 'Конструктор Меню';
$lang['help'] = '<h3> Для чего нужен этот модуль? </h3>
  <p>Модуль &quot;Навигатор&quot; - это скрипт для генерации навигации (меню) из дерева контента CMSMS и шаблона smarty. Этот модуль предоставляет гибкие возможности фильтрации, позволяющие создавать множество вариантов навигации на основе различных критериев, и простой в использовании иерархический формат данных для создания меню сайта с большими возможностями. </p>
  <p> Этот модуль не имеет собственного интерфейса администратора, вместо этого он использует менеджер Дизайна (DesignManager) для управления шаблонами меню. </p>
<h3> Как использовать этот модуль? </h3>
<p> Самый простой способ использовать этот модуль - вставить тег <code> {Navigator} </code> в шаблон. Модуль принимает множество параметров для изменения своего поведения и фильтрации данных. </p>
<h3> Почему нужны шаблоны? </h3>
<p> В этом кроется вся сила CMSMS. Навигация может быть построена автоматически с использованием данных из вашей иерархии страниц и smarty шаблона. Нет необходимости редактировать шаблон меню каждый раз, когда страница сайта добавляется или удаляется из системы. Кроме того, шаблоны навигации могут легко включать JavaScript или расширенные функции и могут использоваться на разных веб-сайтах. </p>
<p> Этот модуль распространяется с несколькими образцами шаблонов, это всего лишь образцы. Вы можете свободно копировать их и изменять  по своему вкусу. Стилизация меню выполняется путем редактирования таблицы стилей в CMSMS. Таблицы стилей не входят в состав модуля &quot;Навигатор&quot;. </p>
<h3> Объект меню: </h3>
  <p> Каждый шаблон меню содержит массив объектов node, который содержит параметры элемента меню сайта. Ниже приводится описание этого ключевого объекта: </p>
<ul>
  <li> $ node-> id - Номер элемента меню. </li>
  <li> $ node-> type - Тип элемента меню. То есть: содержание, ссылка, ссылка на страницу и т.д. </li>
  <li> $ node-> url - URL-адрес элемента меню. Его следует использовать при создании ссылок. </li>
  <li> $ node-> accesskey - ключ доступа, если он определен. </li>
  <li> $ node-> tabindex - индекс вкладки, если он определен. </li>
  <li> $ node-> titleattribute - Описание или атрибут description, если он определен. </li>
  <li> $ node-> иерархия - Положение элемента меню в иерархии. (например, 1.3.3) </li>
  <li> $ node-> default - ИСТИНА, если этот элемент меню ссылается на страницу по умолчанию. </li>
  <li> $ node-> menutext - Текст меню </li>
  <li> $ node-> raw_menutext - текст меню без преобразования HTML-сущностей </li>
  <li> $ node-> alias - псевдоним (алиас) страницы </li>
  <li> $ node-> extra1 - это поле содержит значение свойства страницы extra1, если для параметра loadprops не установлено значение НЕ загружать свойства. </li>
  <li> $ node-> extra2 - это поле содержит значение свойства страницы extra2, если для параметра loadprops не установлено значение НЕ загружать свойства. </li>
  <li> $ node-> extra3 - это поле содержит значение свойства страницы extra3, если для параметра loadprops не установлено значение НЕ загружать свойства. </li>
  <li> $ node-> image - это поле содержит значение свойства страницы изображения (если не пусто), если для параметра loadprops не задано значение НЕ загружать свойства. </li>
  <li> $ node-> thumbnail - это поле содержит значение свойства страницы эскиза (если не пусто), если для параметра loadprops не установлено значение НЕ загружать свойства. </li>
  <li> $ node-> target - это поле содержит цель для ссылки (если не пусто), если для параметра loadprops не установлено значение НЕ загружать свойства. </li>
  <li> $ node-> created - Дата создания элемента меню </li>
  <li> $ node-> modified - Дата изменения элемента меню </li>
  <li> $ node-> parent - ИСТИНА, если этот элемент меню является родительским для текущей выбранной страницы. </li>
  <li> $ node-> current - ИСТИНА, если этот элемент меню является текущей выбранной страницей. </li>
  <li> $ node-> children_exist - ИСТИНА, если у этого элемента меню есть дочерние элементы. </li>
  <li> $ node-> children - массив элементов меню, которые явлются дочерними для данного элемента меню. Не устанавливается, если у элемента меню нет дочерних элементов для отображения. </li>
  <li> $ node-> has_children - ИСТИНА, если у этого элемента меню есть дочерние элементы, которые могут отображаться, но не отображаются из-за других параметров фильтрации (количество уровней и т. д.). </li>
</ul>
<h3> Примеры: </h3>
<ul>
   <li> Простая двухуровневая навигация с использованием шаблона по умолчанию: <br/>
     <pre> <code> {Navigator number_of_levels = 2} </code> </pre>
   </li>
     <li> Отобразить простую навигацию на два уровня, начиная с дочерних элементов текущей страницы. Используйте шаблон по умолчанию: </li>
     <pre> <code> {Navigator number_of_levels = 2 start_page = $page_alias} </code> </pre>
   </li>
   <li> Отобразить простую навигацию на два уровня, начиная с дочерних элементов текущей страницы. Используйте шаблон по умолчанию: </li>
     <pre> <code> {Navigator number_of_levels = 2 childrenof = $page_alias} </code> </pre>
   </li>
   <li> Отображать навигацию на два уровня глубиной, начиная с текущей страницы, ее одноранговых элементов и всего, что ниже них. Используйте шаблон по умолчанию: </li>
     <pre> <code> {Navigator number_of_levels = 2 start_page = $page_alias show_root_siblings = 1} </code> </pre>
   </li>
   <li>Отображение навигации по указанным пунктам меню и их дочерним элементам. Используется шаблон с именем mymenu</li>
     <pre><code>{Navigator items=\'alias1,alias2,alias3\' number_of_levels=3 template=mymenu}</code></pre>
   </li>
</ul>';
$lang['help_action'] = 'Укажите действие модуля (action). Этот модуль поддерживает два действия:
<ul>
   <li> <em> default </em> - используется для создания основной навигации (используется по умолчанию). </li>
   <li> breadcrumbs - используются для создания мини-навигации, состоящей из пути от корня сайта до текущей страницы. </li>
</ul>';
$lang['help_collapse'] = 'Если включено, то будут выводится страницы, которые связаны с текущей активной страницей.';
$lang['help_childrenof'] = 'Эта опция выводит только страницы, которые являются дочерними для страницы с указанным алиасом или id, например: <code>{Navigator childrenof=$page_alias}</code>.';
$lang['help_excludeprefix'] = 'Исключить все страницы (в том числе их дочерние страницы), алиас которых соответствует одному из указанных (разделенных запятыми) алиасов. Этот параметр нельзя использовать вместе с параметром includeprefix.';
$lang['help_includeprefix'] = 'Включать только те страницы, псевдоним которых соответствует одному из указанных алиасов (разделенных запятыми). Этот параметр нельзя комбинировать с параметром excludeprefix.';
$lang['help_items'] = 'Определяет список псевдонимов (алиасов) страниц, разделенных запятыми, которые должны отображаться в этом меню сайта.';
$lang['help_loadprops'] = 'Используйте этот параметр, если НЕ используете расширенные свойства в шаблоне меню. Это отключит загрузку ненужных свойств каждой страницы (например, extra1, image, thumbnail и т. д.). Это значительно уменьшит количество запросов, необходимых для построения меню, и уменьшит требования к памяти, но сделает невозможным создание более сложных вариантов навигации по сайту.';
$lang['help_nlevels'] = 'Алиас (псевдоним) для number_of_levels';
$lang['help_number_of_levels'] = 'Этот параметр ограничит глубину созданной навигации указанным количеством уровней. По умолчанию подразумевается, что значение этого параметра не ограничено, за исключением случаев использования параметра items, в этом случае параметр number_of_levels подразумевается равным 1.';
$lang['help_root2'] = 'Используется только в & quot; breadcrumbs & quot; action. Этот параметр указывает, что меню "хлебные крошки" не должно содержать ссылки на страницы выше указанного алиаса страницы. При указании отрицательного целого числа хлебные крошки будут отображаться только до верхнего уровня, а страница по умолчанию будет игнорироваться.';
$lang['help_show_all'] = 'Эта опция заставит меню отображать все страницы сайта, даже если они отключены для вывода в меню. Однако по-прежнему не будет выводиться неактивные страницы.';
$lang['help_show_root_siblings'] = 'Эта опция является полезной, только если используются start_element или start_page. В результате будут выводиться  страницы того же уровня что и start_page/element (их братья и сёстры).';
$lang['help_start_element'] = 'Выводить элементы меню начиная с заданного start_element и показывает только этот элемент и его дочерние элементы. В параметре надо указать позицию в иерархии страниц (например, 5.1.2).';
$lang['help_start_level'] = 'При выборе этого параметра в меню будут отображаться только элементы, начинающиеся с заданного уровня относительно текущей страницы. Простой пример: если бы у вас было одно меню на странице с number_of_levels = 1, затем в качестве второго меню у вас start_level = 2., то ваше второе меню будет отображать элементы в зависимости от того, что выбрано в первом меню. Минимальное значение этого параметра - 2.';
$lang['help_start_page'] = 'Выводит меню начиная со страницы start_page и показывает только эту страницу и дочерние элементы. В качестве значения параметра нужно указать алиас страницы.';
$lang['help_template'] = 'Шаблон для отображения меню. Название шаблон должно присутствовать в менеджере дизайна (DesignManager), иначе будет отображаться ошибка. Если этот параметр не указан, будет использоваться шаблон по умолчанию типа Navigator :: Navigation.';
$lang['help_start_text'] = 'Этот параметр полезен только в action "breadcrumbs". Он позволяет указать некоторый дополнительный текст для отображения в начале навигации по хлебным крошкам. Примером может быть & quot; Вы здесь & quot;';
$lang['type_breadcrumbs'] = 'Хлебные крошки';
$lang['type_Navigator'] = 'Навигатор';
$lang['type_navigation'] = 'Навигация по сайту';
$lang['youarehere'] = 'Вы здесь';
$lang['ga'] = 'GA1.2.611571213.1605102845';
$lang['gid'] = 'GA1.2.1383910371.1610736661';
?>