<?php
$lang['admindescription'] = 'Eine abgespeckte, aber immer noch leistungsfähige Umsetzung des TinyMCE-WYSIWYG-Editor.';
$lang['browse'] = 'Durchsuchen';
$lang['cancel'] = 'Abbrechen';
$lang['class'] = 'Klasse';
$lang['cmsms_linker'] = 'Link zur CMS-Made-Simple-Seite';
$lang['css_styles_help'] = 'Die hier eingegebenen CSS-Stil-Namen werden dem Listenfeldmenü im Editor hinzugefügt. Wenn Sie das Eingabefeld leer lassen, wird das entsprechende Listenfeldmenü nicht angezeigt (= voreingestellt).';
$lang['css_styles_help2'] = '<p>Die Stile können entweder der Name der CSS-Klasse oder aber ein neuer Name (quasi ein Alias) für eine CSS-Klasse sein. Sie müssen entweder durch Kommata oder einen Zeilenumbruch voneinander getrennt werden.</p>
<p>Beispiel: meinstil1, Mein Stilname=meinstil2</p>
<p>Ergebnis: ein Listenfeldmenü mit zwei Einträgen \'meinstil2\' und \'Mein Stilname\', bei deren Anwendung entsprechend die Klasse meinstil1 bzw. meinstil2 eingefügt wird.</p>
<p>HINWEIS: Es wird nicht überprüft, ob diese Stil-Namen existieren, sondern ohne Kontrolle verwendet.</p>';
$lang['css_styles_text'] = 'CSS-Stile';
$lang['description'] = 'Beschreibung';
$lang['dimensions'] = 'B×H';
$lang['dimension'] = 'Abmessung';
$lang['dirinfo'] = 'Arbeitsverzeichnis ändern zu';
$lang['edit_image'] = 'Bild bearbeiten';
$lang['edit_profile'] = 'Profil bearbeiten';
$lang['error_cantchangesysprofilename'] = 'Der Name eines Systemprofils kann nicht geändert werden';
$lang['error_missingparam'] = 'Ein erforderlicher Parameter fehlt';
$lang['error_nopage'] = 'Kein Seiten-Alias ausgewählt';
$lang['example'] = 'Anwendungsbeispiel MicroTiny';
$lang['filepickertitle'] = 'Dateiauswahl';
$lang['friendlyname'] = 'MicroTiny-WYSIWYG-Editor';
$lang['fileview'] = 'Dateiansicht';
$lang['filename'] = 'Dateiname';
$lang['filterby'] = 'Filtern nach';
$lang['height'] = 'Höhe';
$lang['help'] = '<h3>Was macht dieses Modul?</h3>
<p>MicroTiny ist eine kleine, eingeschränkte Version des <a href=\\\'http://www.tinymce.com\\\' target=\\\'_blank\\\'>TinyMCE</a>-Editors, der Redakteuren ein nahezu der realen Website entsprechendes Erscheinungsbild für das Bearbeiten von Inhalten ermöglicht. Es funktioniert mit Inhaltselementen in CMSMS-Inhaltseiten (wenn ein WYSIWYG-Editor zugelassen wurde), in Modul-Administrationsformularen, in denen WYSIWYG-Editoren zugelassen sind, und ermöglicht eingeschränkte Funktionen zum Bearbeiten von HTML-Blöcken auf öffentlichen Seiten.</p>
<p>Damit MicroTiny als WYSIWYG-Editor in der Administratoroberfläche verwendet werden kann, muss der MicroTiny-Editor in den Benutzereinstellungen ausgewählt werden. Bitte wählen Sie „MicroTiny“ in der Option „WYSIWYG-Editor auswählen“ unter „Meine Einstellungen » Benutzereinstellungen“ im CMSMS-Administrationsbereich. Zusätzliche Optionen in verschiedenen Modulen oder in Seitenvorlagen und Inhaltseiten können steuern, ob ein Textfeld oder ein WYSIWYG-Feld in verschiedenen Bearbeitungsformularen angezeigt wird.</p>
<p>Für Frontend-Bearbeitungsfunktionen muss MicroTiny als „Frontend-WYSIWYG“ in der globalen Einstellungsseite der CMSMS-Administratoroberfläche ausgewählt werden.</p>
<h3>Funktionen:</h3>
<ul>
	<li>Unterstützt eine Teilmenge der HTML5-Block- und Inline-Elemente.</li>
	<li>Separate Profile für Administratoren-Editoren und Frontend-Editoren.</li>
	<li>Eine benutzerdefinierte Dateiauswahl zum Auswählen zuvor hochgeladener Medien.</li>
	<li>Ein eigenes Plugin zum Erstellen von Links zu CMSMS-Inhaltseiten <em>(nur Admin)</em>.</li>
	<li>Eingeschränkt anpassbare Profile für Administratoren-Verhalten und Frontend-Verhalten.</li>
	<li>Anpassbares Erscheinungsbild durch Angabe eines zu verwendenden Stylesheets für den Editor.</li>
</ul>
<h3>Wie verwende ich es?</h3>
<ul>
	<li>Installieren und konfigurieren Sie das Modul</li>
	<li>Stellen Sie MicroTiny als Ihren WYSIWYG-Editor der Wahl in „Meine Einstellungen“ ein</li>
</ul>
<h3>Über HTML, TinyMCE und Inhaltserstellung:</h3>
<dl>
	<dt>WYSIWYG-ähnlicher Editor</dt>
	<dd>
		<p>Dieser Editor bietet die Möglichkeit, Inhalte in einer Umgebung zu bearbeiten, die der beabsichtigten Ausgabe auf der öffentlichen Seite ähnlich <em>(aber nicht unbedingt identisch)</em> ist. Zahlreiche Faktoren können Unterschiede beeinflussen, einschließlich:</p>
		<ul>
			<li>Unvollständige oder fehlerhafte Stylesheets</li>
			<li>Verwendung von fortgeschrittener Formatierung, die der Editor nicht verstehen kann</li>
			<li>Verwendung von HTML-Elementen, die der WYSIWYG nicht versteht.</li>
		</ul>
	</dd>

	<dt>Teilmenge der HTML-Elemente</dt>
	<dd>
		<p>Als einfacher Inhaltseditor unterstützt dieser Editor nicht alle HTML-Elemente (insbesondere nicht die neuen HTML5-Blockelemente). Alle Elemente, die der Editor nicht versteht oder unterstützt, werden beim Speichern aus dem Inhalt entfernt. Als Faustregel <em>(ohne <div>)</em> können Sie davon ausgehen, dass der Editor nur die Elemente unterstützt, die über die verschiedenen Menü- und Symbolleistenoptionen direkt verfügbar sind.</p>
	</dd>

	<dt>Bearbeiten von Inhaltselementen, nicht der gesamten Seite</dt>
	<dd>
		<p>Da CMS Made Simple eine Umgebung ist, die Layoutvorlagen und Smarty-Elementen nutzt, ist vorgesehen, dass der WYSIWYG-Editor nur für bestimmte Inhaltselemente oder Datenelemente (d. h. den Hauptinhaltsbereich einer Seite oder die Beschreibung für einen Nachrichten- oder Blogartikel) verwendet wird. Dieses Modul <em>(und CMSMS)</em> unterstützen keine vollständige Seitenlayoutbearbeitung.</p>
	</dd>

	<dt>Für einfache Inhaltsbearbeitung, nicht für Design</dt>
	<dd>
		<p>Die Absicht und der Zweck dieses Moduls ist es, eine WYSIWYG-ähnliche Umgebung bereitzustellen, in der Redakteure Inhalte in bestimmten Blöcken mit begrenzten Formatierungsmöglichkeiten einfügen und bearbeiten können, ohne die Gestaltung der Seitenvorlage zu beeinflussen oder zu überschreiben. Es ist nicht dafür gedacht und wird auch nicht als allgemeiner HTML- oder Layout-Editor unterstützt.</p>
		<p>Webentwickler sollten die oben genannten Punkte verstehen, davon ausgehen, dass Redakteure in einem WYSIWYG-Bereich bearbeiten können und werden, und sicherstellen, dass dort nur einfache Inhalte vorhanden sind. Wenn für einen bestimmten Bereich fortgeschrittene Layouttechniken erforderlich sind, sollten Entwickler die entsprechenden Vorlagen so anpassen, dass der Editor mit eingeschränkter Funktionalität ordnungsgemäß funktioniert.</p>
	</dd>

	<dt>Trennung von Logik, Funktionalität und Design von Inhalten</dt>
	<dd>
		<p>Dieser Editor geht davon aus, dass Inhalte für einen bestimmten Bereich einer Seite (oder einen Blogartikel, Nachrichtenartikel, eine Produktbeschreibung etc.) Daten sind. Die Daten werden von den entsprechenden Vorlagen gestaltet und sollten nicht mit Gestaltungselementen oder der Funktionalität der Website vermischt werden.</p>
		<p>Als einfaches Beispiel: Wenn Sie darauf bestehen, dass Editoren bestimmte Klassen für Bilder verwenden, ihre Bilder auf eine bestimmte Art und Weise anordnen oder Blockelemente wie <div> oder <section> in ihre Inhalte einfügen, um eine ordnungsgemäße Formatierung zu erzielen, dann ist dies nicht das richtige Editor-Modul für Sie. Solche Formatierungsaspekte sollten in Stylesheets und Vorlagen behandelt werden, so dass ein Redakteur Text eingeben kann, ohne sich an Regeln erinnern zu müssen.</p>
		<p>Dieses Modul ist nicht dafür ausgelegt, Sonderfälle zu behandeln, in denen fortgeschrittenes HTML erforderlich ist. In solchen Seiten sollte der WYSIWYG-Editor deaktiviert und der Bearbeitungszugriff auf die Seite auf diejenigen beschränkt werden, die in der Lage sind, HTML-Code manuell zu verstehen und zu bearbeiten.</p>
		<p>Da dieses Modul dazu gedacht ist, einen eingeschränkten Editor für bestimmte Blöcke bereitzustellen, der von Redakteuren ohne HTML-Kenntnisse verwendet werden kann, sollten Sie (als allgemeine Regel) Smarty-Logik oder Modulaufrufe NICHT in WYSIWYG-aktivierten Bereichen mischen. Es ist am besten, den WYSIWYG für diese Bereiche/Seiten zu deaktivieren und den Bearbeitungszugriff auf diese Seiten zu beschränken.</p>
	</dd>
</dl>
<h3>Über Bilder und Medien:</h3>
<p>Jedes Profil hat die Möglichkeit, die Fähigkeit des Ediors, Bild- oder Medienelemente grafisch in den bearbeiteten Inhalt einzufügen, zu aktivieren und zu deaktivieren. Dies ist in stark strukturierten Umgebungen nützlich, in denen Bilder und andere Medien auf andere Weise in die endgültige Ausgabe einbezogen werden können. Insbesondere bei Frontend-Bearbeitungsformularen, bei denen die Identität des Benutzers nicht unbedingt vertrauenswürdig ist, wird empfohlen, dass Benutzer nicht die Möglichkeit haben, Bilder oder andere Medien einzufügen.</p>
<p><strong>Hinweis:</strong> Dieses Modul bietet nicht die Möglichkeit, Dateien, Bilder oder Medien hochzuladen oder anderweitig zu bearbeiten. Diese Funktionalität wird anderweitig in CMSMS behandelt.</p>

<h3>Über Frontend-Bearbeitung:</h3>
<p>Dieses Modul bietet ein einzigartiges „Profil“ zum Konfigurieren des WYSIWYG-Editors für Frontend-Anfragen. Standardmäßig ist das Frontend-Profil stark eingeschränkt.</p>
<p>Um Frontend-WYSIWYG-Editoren zu aktivieren, muss der Code <code>{cms_init_editor}</code> im Head-Teil der Vorlage enthalten sein. Außerdem muss dieses Modul als „Frontend-WYSIWYG“ in der globalen Einstellungsseite der CMSMS-Administratoroberfläche eingestellt werden.</p>

<h3>Über Stile und Farben:</h3>
<p>Dieses Modul bietet die <em>(optionale)</em> Möglichkeit, ein Stylesheet mit dem Profil zu verknüpfen. Dies ermöglicht es, den Bearbeitungsbereich des WYSIWYG-Editors in einer dem Website-Stil ähnlichen Weise zu gestalten. Dies bietet dem Redakteur ein realistischeres Bearbeitungserlebnis.</p>
<p>Darüber hinaus ermöglicht dieses Modul in Verbindung mit dem <code>classname</code>-Parameter der Tags <code>{cms_textarea}</code> und <code>{content}</code> dem Editor-Modul, das angegebene Stylesheet für jeden Inhaltsblock unterschiedlich zu überschreiben. Dies ermöglicht es, jeden WYSIWYG-Bereich unterschiedlich zu gestalten, wenn es mehrere WYSIWYG-Bereiche auf der Seite gibt. Diese Funktionalität ist auf die Administratoroberfläche beschränkt.</p>
<p>Zum Beispiel ermöglicht das Hinzufügen des Parameters <code>cssname</code> zum <code>{content}</code>-Tag in einer Seitenvorlage die Angabe eines CMSMS-Stylesheets, das verwendet werden soll, um das Erscheinungsbild dieses Inhaltsblockes anzupassen. Beispiel: <code>{content block=\'second block\' cssname=\'whiteonblack\'}</code></p>
<p>Weiterhin ermöglicht eine Einstellung im Abschnitt „Globale Einstellungen“ für das Inhaltsediting das automatische Hinzufügen des Parameters <code>css-name</code> mit dem Namen des Inhaltsblocks.</p>
<h4>Stile für den WYSIWYG-Editor</h4>
     <p>Das Stylesheet für den WYSIWYG-Editorbereich sollte alles vom body-Element abwärts formatieren. Es ist lediglich erforderlich, die Elemente zu formatieren, die dem Inhaltseditor zur Verfügung stehen und von ihm verwendet werden. Hier ist ein einfaches Beispiel eines Stylesheets für ein Weiß-auf-Schwarz-Design:</p>
<pre><code>
body {
 background: black;
 color: white;
}
p {
 margin-bottom: 0.5em;
}
h1 {
 color: yellow;
 margin-bottom: 1em;
}
h2 {
 color: cyan;
 margin-bottom: 0.75em;
}
</code></pre>
<h3>FAQ:</h3>
 <dl>
	<dt>Wo ist die Unterstützung für „diese und jene Funktionen“ im Editor und wie aktiviere ich sie?</dt>
	<dd>Gar nicht. Die mit MicroTiny vertriebene Version von TinyMCE ist ein abgespecktes, benutzerdefiniertes Paket. Wir haben unsere eigenen benutzerdefinierten Plugins hinzugefügt, unterstützen jedoch nicht das Hinzufügen benutzerdefinierter Plugins oder die Möglichkeit, die Konfiguration auf andere Weise als über das Formular zum Bearbeiten des Profils anzupassen. Wenn Sie zusätzliche Funktionen in einem WYSIWYG-Editor benötigen, können Sie mit einem Modul eines Drittanbieters Erfolg haben.</dd>
	<dt>Welche HTML-Tags werden von diesem Modul unterstützt und wie kann ich das ändern?</dt>
	<dd>Die Liste der unterstützten Elemente im Standard-TinyMCE-Editor finden Sie auf der <a href=\\\'https://www.tiny.cloud/docs/tinymce/latest/basic-setup/\\\'>TinyMCE-Website</a>. Im MicroTiny-Modul gibt es keinen Mechanismus, um dies zu erweitern.</dd>
	<dt>Ich bekomme den MicroTiny-Editor in der Admin-Oberfläche nicht zum Laufen, was kann ich tun?</dt>
	<dd>Es gibt einige Schritte, die Sie befolgen können, um dieses Problem zu diagnostizieren:
 		<ol>
	 		<li>Überprüfen Sie das CMSMS-Administratorprotokoll, Ihr PHP-Fehlerprotokoll und die JavaScript-Konsole auf Hinweise auf ein Problem.</li>
	 		<li>Stellen Sie sicher, dass der Beispiel-WYSIWYG-Bereich im MicroTiny-Admin-Panel unter „Erweiterungen >> MicroTiny WYSIWYG-Editor“ funktioniert. Wenn dies nicht funktioniert, überprüfen Sie Ihr PHP-Fehlerprotokoll und Ihre JavaScript-Konsole erneut.</li>
	 		<li>Stellen Sie sicher, dass MicroTiny als „zu verwendender WYSIWYG-Editor“ in Ihren Benutzereinstellungen ausgewählt ist.</li>
	 		<li>Überprüfen Sie andere Inhaltsseiten. Wenn MicroTiny mit einem oder mehreren davon funktioniert, bedeutet dies, dass auf einigen Inhaltsseiten möglicherweise eine Einstellung zum Deaktivieren von WYSIWYG-Editoren für alle Inhaltsblöcke gesetzt ist.</li>
	 		<li>Überprüfen Sie die Seitenvorlage(n). Der Parameter <code>wysiwyg=false</code> kann für einen oder mehrere Inhaltsblöcke in den Seitenvorlagen angegeben werden, wodurch der WYSIWYG-Editor deaktiviert wird.</li>
 		</ol>
	</dd>
	 <dt>Wie füge ich <br/> ein, statt neue Absätze zu erstellen?</dt>
		 <dd>Drücken Sie <kbd>⇧ Umschalt</kbd>-Eingabetaste statt nur der Eingabetaste.</dd>
	 <br/>
	 <dt>Warum sind „diese und jene Funktionen“ in der Menüleiste und nicht in der Symbolleiste verfügbar?</dt>
		 <dd>In den meisten Fällen geschieht dies absichtlich, um Webentwicklern die Möglichkeit zu geben, die Funktionalität bestimmter Editorprofile weiter einzuschränken. Die Menüleiste kann in verschiedenen Profilen ausgeschaltet werden, wodurch dem Benutzer die nur in der Menüleiste verfügbare Funktionalität verweigert wird.</dd>
 </dl>
<h3>Caching</h3>
<p>In einem Versuch, die Leistung zu verbessern, versucht MicroTiny, die generierten JavaScript-Dateien zwischenzuspeichern, es sei denn, etwas hat sich geändert. Diese Funktionalität kann durch Setzen des speziellen Konfigurationseintrags <code>mt_disable_cache</code> auf „true“ deaktiviert werden. Beispiel: Hinzufügen von <code>$config["mt_disable_cache"] = true;</code> zur config.php-Datei.</p>
<h3>Weitere Informationen</h3>
<ul>
	<li><code>{content}</code> tag in „Extensions » Tags“</li>
	<li><code>{cms_textarea}</code> tag in „Extensions » Tags“</li>
	<li><code>{cms_init_editor}</code> tag in „Extensions » Tags“</li>
	<li>Der <a href=\\\'https://www.tiny.cloud/\\\' target=\\\'_blank\\\'>TinyMCE</a>-Editor selbst</li>
</ul>';
$lang['image'] = 'Bild';
$lang['info_linker_autocomplete'] = 'Dies ist ein Feld mit automatischer Vervollständigung. Geben Sie zunächst einige Zeichen des gewünschten Seitenalias, Menütexts oder Titels ein. Alle übereinstimmenden Elemente werden in einer Liste angezeigt.';
$lang['loading_info'] = 'lädt…';
$lang['mailto_image'] = 'Mail-Bild erstellen';
$lang['mailto_text'] = 'Mail-Link erstellen';
$lang['mailto_title'] = 'Mail-Link erstellen';
$lang['msg_cancelled'] = 'Aktion abgebrochen';
$lang['mthelp_allowcssoverride'] = 'Wenn aktiviert, kann jeder Code, der ein MicroTiny-Eingabefeld initialisiert, den Namen eines Stylesheets angeben, das anstelle des oben angegebenen Standard-Stylesheets verwendet werden soll.';
$lang['mthelp_dfltstylesheet'] = 'Ordnen Sie Editoren, die dieses Profil verwenden, ein Stylesheet zu. Dadurch kann das Eingabefeld des Editors dem Erscheinungsbild der Website ähneln.';
$lang['mthelp_profileallowimages'] = 'Einem Redakteur erlauben, Bilder und Videos in den Textbereich einzubetten. Bei sehr streng kontrollierten Designs können die Inhaltsredakteure möglicherweise nur Bilder oder Videos für bestimmte Bereiche einer Webseite auswählen.';
$lang['mthelp_profileallowtables'] = 'Dem Editor erlauben, Tabellen einzubetten und zu bearbeiten. Hinweis: Dies sollte nicht zur Steuerung des Seitenlayouts, sondern nur für tabellarische Daten verwendet werden.';
$lang['mthelp_profilelabel'] = 'Eine Beschreibung für dieses Profil. Die Beschreibung für Systemprofile kann nicht bearbeitet werden.';
$lang['mthelp_profilename'] = 'Der Name für dieses Profil. Namen von Systemprofilen können nicht bearbeitet werden.';
$lang['mthelp_profilemenubar'] = 'Gibt an, ob die Menüleiste in den sichtbaren Profilen aktiviert werden soll. Die Menüleiste hat normalerweise mehr Optionen als die Symbolleiste';
$lang['mthelp_profilestatusbar'] = 'Diese Option gibt an, ob die Statusleiste am unteren Rand des WYSIWYG-Bereichs aktiviert werden soll. Die Statusleiste zeigt einige nützliche Informationen für fortgeschrittene Editoren.';
$lang['mthelp_profileresize'] = 'Diese Option gibt an, ob die Größe des WYSIWYG-Bereichs geändert werden kann. Damit die Größenänderung funktioniert, muss die Statusleiste aktiviert sein.';
$lang['newwindow'] = 'Neues Fenster';
$lang['ok'] = 'OK';
$lang['prompt_linker'] = 'Seitentitel eingeben';
$lang['prompt_linktext'] = 'Link-Text';
$lang['prompt_profiles'] = 'Profile';
$lang['prompt_selectedalias'] = 'Ausgewähltes Seiten-Alias';
$lang['profiledesc___admin__'] = 'Dieses Profil wird von allen Benutzern verwendet, die zur Verwendung dieses Editors berechtigt sind und diesen Editor als WYSIWYG-Editor ausgewählt haben.';
$lang['profiledesc___frontend__'] = 'Dieses Profil wird für alle Frontend-Anfragen verwendet, bei denen dieser WYSIWYG-Editor zulässig ist';
$lang['profile_admin'] = 'Bearbeiter im Administrationsbereich';
$lang['profile_allowcssoverride'] = 'Erlauben Sie Blöcken, das ausgewählte Stylesheet zu überschreiben';
$lang['profile_allowimages'] = 'Bilder erlauben';
$lang['profile_allowresize'] = 'Größenänderungen erlauben';
$lang['profile_allowtables'] = 'Tabellen erlauben';
$lang['profile_dfltstylesheet'] = 'Stylesheet für den Editor';
$lang['profile_frontend'] = 'öffentliche Bearbeiter';
$lang['profile_label'] = 'Etikett';
$lang['profile_name'] = 'Profilname';
$lang['profile_menubar'] = 'Menüleiste anzeigen';
$lang['profile_showstatusbar'] = 'Statusleiste anzeigen';
$lang['prompt_name'] = 'Name';
$lang['prompt_target'] = 'Ziel';
$lang['prompt_class'] = 'class-Attribut';
$lang['prompt_email'] = 'E-Mail-Adresse';
$lang['prompt_insertmailto'] = 'Einen Mail-Link einfügen/bearbeiten';
$lang['prompt_anchortext'] = 'Ankertext';
$lang['prompt_rel'] = 'rel-Attribut';
$lang['prompt_texttodisplay'] = 'anzuzeigender Text';
$lang['savesettings'] = 'Einstellungen speichern';
$lang['settings'] = 'Einstellungen';
$lang['settingssaved'] = 'Einstellungen gespeichert';
$lang['size'] = 'Größe';
$lang['submit'] = 'Absenden';
$lang['switchgrid'] = 'zur Gitteransicht wechseln';
$lang['switchlist'] = 'zur Listenansicht wechseln';
$lang['switchimage'] = 'Bilddateien anzeigen';
$lang['switchvideo'] = 'Videodateien anzeigen';
$lang['switchaudio'] = 'Audiodateien anzeigen';
$lang['switcharchive'] = 'Achivdateien anzeigen';
$lang['switchfiles'] = 'Dateien anzeigen';
$lang['switchreset'] = 'Alle anzeigen';
$lang['tooltip_selectedalias'] = 'Dieses Feld ist nur lesbar';
$lang['title_cmsms_linker'] = 'Einen Verweis auf eine CMS-Seite erstellen';
$lang['title_cmsms_filebrowser'] = 'Datei auswählen';
$lang['title_edit_profile'] = 'Profil bearbeiten';
$lang['tmpnotwritable'] = 'Die Konfiguration konnte nicht in das /tmp-Verzeichnis geschrieben werden! Bitte beheben Sie diesen Fehler!';
$lang['tab_general_title'] = 'Allgemein';
$lang['tab_advanced_title'] = 'Erweitert';
$lang['type'] = 'Typ';
$lang['usestaticconfig_help'] = 'Damit wird die Konfiguration in eine statische Datei geschrieben (anstatt der dynamischen Erstellung). Dies funktioniert bei bestimmten Servern besser (insbesondere dann, wenn PHP als CGI-Modul läuft)';
$lang['usestaticconfig_text'] = 'Statische Konfiguration verwenden';
$lang['width'] = 'Breite';
$lang['view_source'] = 'Quellcode anzeigen';
$lang['youareintext'] = 'Momentanes Verzeichnis';
?>