<?php
$lang['help_function_page_selector'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин для панели администратора. Позволяет администратору сайта выбирать страницу, которая будет сохранена в настройках. </p>
<h3> Использование: </h3>
<pre> <code> {page_selector name=dfltpage value=$currentpage} </code> </pre>
<h3> Какие параметры нужны? </h3>
<ul>
   <li> name - <em> (строка) </em> - имя поля ввода. </p>
   <li> value - <em> (int) </em> - id текущей выбранной страницы. </p>
   <li> allowcurrent - <em> (bool) </em> - разрешать или запрещать выбор текущего элемента (страницы). Значение по умолчанию - false.</li>
   <li> allow_all - <em> (bool) </em> - разрешать или запрещать выбор неактивных элементов контента или элементов контента, не имеющих полезных ссылок. Значение по умолчанию - false. </li>
   <li> for_child - <em> (bool) </em> - указывает, что мы выбираем родительскую страницу для нового элемента контента. Значение по умолчанию - false. </p>
   </li>
</ul>';
$lang['help_function_cms_html_options'] = '<h3> Для чего это нужно? </h3>
<p> Это мощный плагин для вывода html тегов options  в теге select. У каждого тега option могут быть дочерние элементы, собственный атрибут класса и заголовка. </p>
<h3> Использование: </h3>
<pre> <code> {cms_html_options options = $options [selected = value]} </code> </pre>
<h3> Какие параметры нужны? </h3>
<ul>
  <li> options - <em> (array) </em> - массив с параметрами для тегов option. </li>
  <li> selected - <em> (строка) </em> - значение, которое автоматически выбирается в раскрывающемся списке. Должен совпадать со значением одного из элементов option. </li>
</ul>
<h4> Параметры </h4>
<p> Каждый вариант параметров для option представляет собой ассоциативный массив с двумя или более элементами из следующих: </p>
<ul>
  <li> label - <em> (<strong> обязательная </strong> строка) </em> метка для тега option (это то, что показывается пользователю) </li>
  <li> value - <em> (<strong> обязательно, </strong> смешанный) </em> Либо строковое значение, либо массив параметров.
    <p> Если значение параметра само по себе является массивом параметров, то метка будет отображаться как optgroup с дочерними элементами. </p>
  </li>
  <li> title - <em> (строка) </em> Атрибут заголовка для option. </li>
  <li> class - <em> (строка) </em> Имя класса для option. </li>
</ul>
<h3>Пример:</h3>
<pre><code>
{$opts[]=[\'label\'=>\'Bird\',\'value\'=>\'b\',\'title\'=>\'I have a pet bird\']}
{$opts[]=[\'label\'=>\'Fish\',\'value\'=>\'f\']}
{$sub[]=[\'label\'=>\'Small Dog\',\'value\'=>\'sd\']}
{$sub[]=[\'label\'=>\'Medium Dog\',\'value\'=>\'md\']}
{$sub[]=[\'label\'=>\'Large Dog\',\'value\'=>\'ld\']}
{$opts[]=[\'label\'=>\'Dog\',\'value\'=>$sub]}
{$opts[]=[\'label\'=>\'Cat\',\'value\'=>\'c\',\'class\'=>\'cat\']}
&lt;select name=&quot;pet&quot;&gt;
  {cms_html_options options=$opts selected=\'md\'}
&lt;/select&gt;</code></pre>';
$lang['help_modifier_cms_date_format'] = '<h3> Для чего это нужно? </h3>
<p> Этот модификатор используется для форматирования дат в нужном формате. Он использует стандартные параметры strftime. Если строка формата не указана, система будет использовать предпочтение пользователя для формата даты (для вошедших в систему пользователей) или формат системной даты. </p>
<p> Этот модификатор способен распознавать даты во многих форматах. То есть: строки даты и времени, выводимые из базы данных, или целочисленные временные метки, созданные функцией time(). </p>
<h3> Использование: </h3>
<pre> <code> {$ some_date_var|cms_date_format[: &lt; строка формата &gt;]} </code> </pre>
<h3> Пример: </h3>
<pre> <code> {\'2012-03-24 22: 44: 22\'|cms_date_format} </code> </pre>';
$lang['help_modifier_cms_escape'] = '<h3> Для чего это нужно? </h3>
<p> Этот модификатор используется для экранирования специальных символов строки одним из многих способов. Его можно использовать для преобразования строки в несколько различных форматов или для отображения введенных пользователем данных со специальными символами на веб-странице. </p>
<h3> Использование: </h3>
<pre> <code> {$some_var_with_text|cms_escape[:&lt; escape type &gt;|[&lt; набор символов &gt;]]} </code> </pre>
<h4> Допустимые типы экранирования: </h4>
<ul>
<li> html <em> (по умолчанию) </em> - использует функция php htmlspecialchars. </li>
<li> htmlall - использует функцию php htmlentities. </li>
<li> url - кодирует URL-строку. </li>
<li> urlpathinfo - аналогично url, но также кодирует знак /. </li>
<li> quotes - экранирует одинарные кавычки. </li>
<li> hex - преобразование каждого символа в шестнадцатеричный код. </li>
<li> hexentity - кодирует каждый символ в шестнадцатиречный код. </li>
<li> decentity - кодирует каждый символ в десятиричный код. </li>
<li> javascript - экранирует кавычки, обратную косую черту, новою строку и т. д. </li>
<li> mail - кодирует адрес электронной почты во что-то, что будет безопасно отображать на сайте. </li>
<li> nonstd - исключение нестандартных символов, таких как кавычки в документе. </li>
</ul>
<h4> Набор символов :: </h4>
<p> Если набор символов не указан, предполагается использование utf-8. Набор символов применим только к &quot; html &quot; и &quot; htmlall &quot; типам экранирования. </p>';
$lang['help_modifier_relative_time'] = '<h3> Для чего это нужно? </h3>
   <p> Этот модификатор преобразует целочисленную метку времени или строку времени/даты в удобочитаемый формат времени от или до настоящего момента. то есть: &quot; 3 часа назад &quot; </p>
<h3> Какие параметры он принимает? </h3>
  <p> Этот модификатор не принимает никаких дополнительных параметров. </p>
<h3> Пример: </h3>
   <code><pre>{$some_timestamp|relative_time}</code></pre>';
$lang['help_modifier_summarize'] = '<h3> Для чего это нужно? </h3>
<p> Этот модификатор используется для обрезания длинной последовательности текста до нужного числа &quot;слов&quot;. </p>
<h3> Использование: </h3>
<pre><code>{$some_var_with_long_text|summarize:&lt;number&gt;}</code> </pre>
<h3> Пример: </h3>
<p> В следующем примере из содержимого удаляются все теги html и они усекаются после 50 слов. </p>
<pre><code>{content|strip_tags|summarize:50}</code> </pre>';
$lang['help_function_admin_icon'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин предназначен только для администратора и позволяет модулям легко отображать иконки из текущей административной темы. Эти значки полезны для создания ссылок или отображения информации о статусе. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
  <li> icon - <strong> (обязательно) </strong> - имя файла иконки, т.е. run.gif </li>
  <li> height - <em> (необязательно) </em> - высота (в пикселях) иконки. </li>
  <li> width - <em> (необязательно) </em> - ширина (в пикселях) иконки. </li>
  <li> alt - <em> (необязательно) </em> - необязательный текст для тега img. </li>
  <li> rel - <em> (необязательно) </em> - необязательный атрибут rel для тега img. </li>
  <li> class - <em> (необязательно) </em> - необязательный атрибут класса для тега img. </li>
  <li> id - <em> (необязательно) </em> - необязательный атрибут id для тега img. </li>
  <li> title - <em> (необязательно) </em> - необязательный атрибут заголовка для тега img. </li>
  <li> accesskey - <em> (необязательно) </em> - необязательный символ клавиши доступа для тега img. </li>
  <li> assign - <em> (необязательно) </em> - назначить вывод тега указанной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
<pre> <code> {admin_icon icon = \'edit.gif\' class = \'editicon\'} </code> </pre>';
$lang['help_function_cms_action_url'] = '<h3> Для чего это нужно? </h3>
<p> Это Smarty плагин, полезный для создания URL-ссылки на action скрипт модуля. Этот плагин полезен для разработчиков модулей, которые создают ссылки (либо для Ajax, либо в интерфейсе администратора) для выполнения различных функций или отображения разных данных. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
  <li> module - <em> (необязательно) </em> - имя модуля, для которого создается URL. Этот параметр не требуется, если создается URL-адрес на скрипт модуля в этом же модуле. </li>
  <li> action - <strong> (обязательно) </strong> - имя action скрипта, для которого создается URL. </li>
  <li> returnid - <em> (необязательно) </em> - целочисленный идентификатор страницы, в котором будут отображаться результаты выполнения скрипта. Этот параметр не требуется, если результат должен отображаться на текущей странице или в админке. </li>
  <li> mid - <em> (необязательно) </em> - идентификатор действия модуля. По умолчанию это &​​quot; m1_ &quot; для действий администратора и &quot; cntnt01 &quot; для действий во внешнем интерфейсе. </li>
  <li> forjs - <em> (необязательно) </em> - необязательное целое число (1 или 0), указывающее, что сгенерированный URL-адрес должен подходить для использования в JavaScript. </li>
  <li> assign - <em> (необязательно) </em> - назначить выходной URL-адрес указанной переменной smarty. </li>
</ul>
<p> <strong> Примечание. </strong> Любые другие параметры, которые не принимаются этим плагином, автоматически передаются в action скрипт вызываемого модуля по сгенерированному URL. </p>
<h3> Пример: </h3>
<pre> <code> {cms_action_url module = News action = defaultadmin} </code> <pre>';
$lang['help_function_cms_admin_user'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин выводит информацию об указанном идентификаторе пользователя-администратора. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
   <li> uid - <strong> обязательно </strong> - целочисленный идентификатор пользователя, представляющий действительную учетную запись администратора. </li>
   <li> mode - <em> (необязательно) </em> - рабочий режим. Возможные значения:
     <ul>
       <li> username <strong> default </strong> - вывести имя пользователя для указанного uid. </li>
       <li> email - вывести адрес электронной почты для указанного uid. </li>
       <li> firstname - вывести имя для указанного uid. </li>
       <li> lastname - вывести фамилию для указанного uid. </li>
       <li> fullname - вывести полное имя для указанного uid. </li>
     </ul>
   </li>
   <li> assign - <em> (необязательно) </em> - назначить вывод указанной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
<pre> <code> {cms_admin_user uid = 1 mode = email} </code> </pre>';
$lang['help_function_cms_get_language'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин возвращает название текущего языка CMSMS. Язык используется для строк перевода и форматирования даты. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <em> (необязательно) assign </em> - назначить вывод плагина указанной переменной smarty. </li>
</ul>';
$lang['help_function_cms_help'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин используется только в панели администратора, Предназначен для создания ссылки, при нажатии на которую будет отображаться всплывающая справка для определенного элемента. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> key - <strong> (обязательная строка) </strong> - вторая часть уникального ключа, определяющая отображаемую строку справки. Обычно это ключ из соответствующего lang-файла. </li>
<li> realm - <em> (необязательная строка) </em> - первая часть уникального ключа для идентификации строки справки. Если этот параметр не указан, и этот плагин вызывается из модуля, то используется текущее имя модуля. Если имя модуля не найдено, тогда &quot; help &quot; используется как realm. </li>
<li> title - <em> (необязательная строка) </em> - заголовок окна справки </li>
<li> assign - <em> (необязательная строка) </em> - присвоить вывод указанной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
<pre> <code> {cms_help key2 = \'help_field_username\' title = &#36; foo} </code> </pre>';
$lang['help_function_cms_init_editor'] = '<h3> Для чего это нужно? </h3>
  <p> Этот плагин используется для инициализации выбранного визуального редактора WYSIWYG для отображения, когда функции WYSIWYG требуются для отправки данных из фронтенда. Этот модуль найдет выбранный редактор WYSIWYG <em> (см. Глобальные настройки). </em>, определит, был ли он запрошен, и, если да, сгенерирует соответствующий html-код <em> (обычно ссылки JavaScript) </em>, чтобы редактор WYSIWYG моге правильно инициализироваться при загрузке страницы. Если для страницы фронтенда не было запрошено никаких редакторов WYSIWYG, этот плагин не выдаст никаких результатов. </p>
<h3> Как мне его использовать? </h3>
<p> Первое, что вам нужно сделать, это выбрать редактор WYSIWYG для использования на странице глобальных настроек в консоли администратора. Далее Если вы используете редакторы WYSIWYG на множестве страниц, возможно, лучше всего разместить плагин {cms_init_editor} прямо в шаблоне страницы. Если вам требуется, чтобы редактор WYSIWYG был включен только на ограниченном количестве страниц, вы можете просто поместить его в поле «Метаданные для данной страницы» для  нужной страницы. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <em> (необязательно) assign </em> - назначить вывод плагина указанной переменной smarty. </li>
</ul>';
$lang['help_function_cms_lang_info'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин возвращает объект, содержащий информацию о выбранном языке, который включен в инсталяцию CMSMS. Объект может содержать информацию о языковом стандарте, кодировках, языковых псевдонимах и т. д. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <em> (необязательно) lang </em> - язык, для которого требуется вернуть информацию. Если параметр lang не указан, используется информация для текущего языка CMSMS. </li>
<li> <em> (необязательно) assign </em> - назначить вывод плагина указанной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
<pre> {cms_lang_info assign = \'nls\'} {$nls->locale()} </pre>
<h3> См. также: </h3>
<p> документация по классу CmsNls. </p>';
$lang['help_function_cms_pageoptions'] = '<h3> Для чего это нужно? </h3>
 <p> Это простой плагин для создания последовательности тегов &lt; option &gt; для раскрывающегося списка select, которые представляют номера страниц в постраничной навигации. </p>
 <p> Учитывая количество страниц и текущую страницу, этот плагин сгенерирует список номеров страниц, который позволит быстро перейти к нужной странице. </p>
<h3> Какие параметры он принимает? </h3>
  <ul>
    <li> numpages - <strong> обязательное целое число </strong> - общее количество доступных для отображения страниц. </li>
    <li> curpage - <strong> обязательное целое число </strong> - номер текущей страницы (должен быть больше 0 и меньше или равен &quot; numpages &quot; </li>
    <li> surround - <em> (необязательное целое число) </em> - количество элементов, окружающих текущую страницу. Значение по умолчанию для этого параметра - 3. </li>
    <li> bare - <em> (необязательное логическое значение) </em> - не выводить &lt; option &gt; теги, вместо этого будет простой массив, пригодный для дальнейших манипуляций в smarty. </li>
  </ul>
<h3> Пример: </h3>
<pre> <code> &lt; select name = &quot;{$actionid}pagenum&quot; &gt; {cms_pageoptions numpages = 50 curpage = 14} &lt; /select &gt; </code> </pre>';
$lang['help_function_share_data'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин используется для копирования одной или нескольких активных переменных smarty в родительскую или глобальную область видимости. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> scope - <strong> необязательная строка </strong> - целевая область, в которую копируются переменные. Возможные значения: &quot; parent &quot; <em> (по умолчанию) </em> или  &quot;global&quot; для копирования данных в глобальный объект smarty для последующего использования везде на сайте. </li>
<li> vars - <strong> смешанный тип </strong> - либо массив имен строковых переменных, либо список имен строковых переменных, разделенных запятыми. </li>
</ul>
<h3> Пример: </h3>
<pre> <code> {share_data scope = global data = \'title, canonical\'} </code> </pre>
<h3> Примечание: </h3>
<p> Этот плагин не принимает методы доступа к массивам или члены объектов в качестве имен переменных. то есть: <code>] $foo[1] </code> или <code> {$foo->bar} </code> не будут работать. </p>';
$lang['help_function_cms_yesno'] = '<h3> Для чего это нужно? </h3>
<p> Это простой плагин, используемый при генерации форм для создания набора опций для <select>, представляющих выбор да/нет. </p>
<p> Этот плагин будет генерировать переведенные варианты да/нет с выбранным значением. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> selected - <em> (необязательно целое число) </em> - либо 0 <em> (нет) </em>, либо 1 <em>(yes)</em> </li>
<li> assign - <em> (необязательная строка) </em> - назначить вывод указанной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
<pre> <code> <select name = &quot;{$actionid}opt&quot;>{cms_yesno selected = $opt} </select> </code> </pre>';
$lang['help_function_module_available'] = '<h3> Для чего это нужно? </h3>
<p> Плагин для проверки того, установлен ли данный модуль (по имени) и доступен ли он для использования. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <strong> (обязательный) модуль </strong> - (строка) имя модуля. </li>
<li> <em> (необязательно) assign </em> - назначить вывод плагина указанной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
{module_available module = \'News\' assign = \'havenews\'} {if $ havenews} {cms_module module = News} {/ if}
<h3> Примечание: </h3>
<p> Вы не можете использовать сокращенную форму вызова модуля, например: <em> {News} </em> в этом типе выражения. </p>';
$lang['help_function_cms_set_language'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин пытается заменить текущий язык для использования в строках перевода и форматировании даты на желаемый язык. Указанный язык должен быть известен CMSMS (файл nls должен существовать). Когда эта функция вызывается (и если она не переопределена в config.php), будет сделана попытка установить локаль на локальную, связанную с языком. На сервере должен быть установлен языковой стандарт для языка. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <strong> (обязательно) lang </strong> - желаемый язык. Язык должен быть известен при установке CMSMS (должен существовать файл nls). </li>
</ul>';
$lang['help_function_browser_lang'] = '<h3> Для чего это нужно? </h3>
  <p> Этот плагин определяет и выводит язык, который принимает браузер пользователя и который присутствует в списке разрешенных языков для определения языка для текущего сеанса браузера. </p>
<h3> Как мне его использовать? </h3>
<p> Вставьте тег на раннем этапе в шаблон страницы <em> (при желании он может располагаться над разделом &lt; head &gt;) </em> и укажите для него имя языка по умолчанию и список допустимых языков (допускается только два символа для обозначения языка), затем что-нибудь сделайте с результатом. </p>
<pre> <code> {browser_lang accept = &quot; de, fr, en, es &quot; default = en assign = tmp} {session_put var = lang val = $tmp} </code> </pre>
<p> <em> ({session_put} - это плагин, предоставляемый модулем CGSimpleSmarty) </em> </p>
<h3> Какие параметры нужны? </h3>
<ul>
<li> <strong> accepted <em>(required)</em> </strong> <br/> - список из допустимых имен языков, разделенных запятыми. </li>
<li> default <br/> - <em> (необязательно) </em> Язык по умолчанию для вывода, если браузер не поддерживает принятый язык. en используется, если не указано другое значение. </li>
<li> assign <br/> - <em> (необязательно) </em> Имя переменной smarty, которой будут назначены результаты. Если не указано иное, возвращаются результаты этой функции. </li>
</ul>';
$lang['help_function_content_module'] = '<h3> Для чего это нужно? </h3>
<p> Этот тип блока контента позволяет взаимодействовать с разными модулями для создания различных типов блоков контента. </p>
<p> Некоторые модули могут определять типы блоков содержимого для использования в шаблонах модулей. Например: модуль FrontEndUsers может определять тип блока содержимого списка групп. Затем он покажет, как вы можете использовать тег content_module для использования этого типа блока в ваших шаблонах. </p>
<p> <strong> Примечание. </strong> Этот тип блока должен использоваться только с совместимыми модулями. Вы не должны использовать это каким-либо образом, кроме как в соответствии с дополнительными модулями. </p>
<p> Этот тег принимает несколько параметров и передает все остальные параметры модулю для обработки. </p>
<p> Параметры:
 <ul>
 <li> <strong> (обязательно) </strong> module - имя модуля, который будет предоставлять этот блок содержимого. Этот модуль должен быть установлен и доступен </li>
 <li> <strong> (обязательный) </strong> block - имя блока содержимого. </li>
 <li> <em> (необязательно) </em> label - метка для блока содержимого, используемая при редактировании страницы. </li>
 <li> <em> (необязательно) </em> required - позволяет указать, что блок содержимого должен содержать некоторый текст. </em> </li>
 <li> <em> (необязательно) </em> tab - желаемая вкладка, на которой будет отображаться это поле в форме редактирования. </li>
 <li> <em> (необязательно) </em> priority (целое число) - позволяет указать целочисленный приоритет для блока на вкладке. </li>
 <li> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </li>
 </ul>
</p>';
$lang['help_function_cms_stylesheet'] = '<h3> Для чего это нужно? </h3>
  <p> Заменяет тег {stylesheet}, обеспечивает кэширование файлов css путем создания статических файлов в каталоге tmp/cache и smarty обработку отдельных таблиц стилей. </p>
  <p> Этот плагин получает информацию о таблицах стилей из системы. По умолчанию он захватывает все таблицы стилей, прикрепленные к текущему шаблону, в порядке, указанном дизайнером, и объединяет их в один тег таблицы стилей. </p>
  <p> Созданным таблицам стилей присваиваются уникальные имена в соответствии с датой последнего изменения в базе данных, и они создаются только в том случае, если таблица стилей была изменена. </p>
  <p> Этот тег заменяет тег {stylesheet}. </p>
  <h3> Как мне его использовать? </h3>
  <p> Просто вставьте тег в раздел заголовка вашего шаблона/ страницы, например: <code>{cms_stylesheet}</code> </p>
  <h3> Какие параметры он принимает? </h3>
  <ul>
  <li> <em> (необязательно) </em> name - вместо получения всех таблиц стилей для данной страницы будет получена только одна с конкретным именем, независимо от того, прикреплена она к текущему шаблону или нет. </li>
  <li> <em> (необязательно) </em> nocombine - (логическое значение, по умолчанию false) Если включено, и с шаблоном связано несколько таблиц стилей, таблицы стилей будут выводиться как отдельные теги, а не объединяться в один тег. </li>
  <li> <em> (необязательно) </em> nolinks - (логическое значение, по умолчанию - false). Если включено, таблицы стилей будут выводиться в виде URL без &lt; link &gt; тега. </li>
  <li> <em> (необязательно) </em> https - (логическое значение, по умолчанию false) указывает, следует ли использовать запись конфигурации ssl_url для префикса URL-адресов таблиц стилей. Если не указан, система попытается определить правильный корневой URL-адрес на основе флага безопасности отображаемой страницы. </li>
  <li> <em> (необязательно) </em> designid - если designid определен, то будут возвращены таблицы стилей, связанные с этим дизайном, вместо текущего. </li>
  <li> <em> (необязательно) </em> media - <strong> [устаревший] </strong> - при использовании вместе с параметром name этот параметр позволит вам переопределить тип носителя для этой таблицы стилей. При использовании вместе с параметром templateid параметр media будет выводить теги таблиц стилей только для тех таблиц стилей, которые отмечены как совместимые с указанным типом мультимедиа. </li>
  </ul>
  <h3> Smarty преобразование </h3>
  <p> При создании файлов css эта система передает таблицы стилей, полученные из базы данных, через smarty. Smarty разделители были изменены со стандарта CMSMS {и} на [[и]] соответственно, чтобы упростить переход в таблицах стилей. Это позволяет создавать умные переменные, например: [[assign var = \'red\' value = \'#900\']] в верхней части таблицы стилей, а затем использовать эти переменные позже в таблице стилей, например: </p>
<pre>
<код>
h3.error {color: [[$red]]; } <br/>
</code>
</pre>
<p> Поскольку кэшированные файлы создаются в каталоге tmp/cache CMSMS, относительный рабочий каталог CSS не является корнем веб-сайта. Поэтому любые изображения или другие теги, для которых требуется URL-адрес, должны использовать тег [[root_url]], чтобы сделать его абсолютным URL-адресом. т.е. </p>
<pre>
<код>
h3.error {background: url([[root_url]]/uploads/images/error_background.gif); } <br/>
</code>
</pre>
<p> <strong> Примечание. </strong> Из-за кеширующей природы плагина переменные smarty должны быть размещены вверху КАЖДОЙ таблицы стилей, прикрепленной к шаблону. </p>';
$lang['help_function_page_attr'] = '<h3> Для чего это нужно? </h3>
<p> Этот тег можно использовать для получения значения атрибутов определенной страницы. </p>
<h3> Как мне его использовать? </h3>
<p> Вставьте тег в шаблон, например: <code> {page_attr key = &quot;extra1&quot;} </code>. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
  <li> <em> (необязательно) </em> page (int | string) - необязательный идентификатор страницы или алиас для получения содержимого. Если не указано, предполагается текущая страница. </li>
  <li> <strong> key [обязательный] </strong> Ключ, атрибут, содержимое которого требуется вернуть.
    <p> Ключ может быть либо именем блока, либо набором стандартных свойств, связанных со страницей контента. Некоторые из принятых стандартных свойств: </p>
    <ul>
      <li> _dflt_ - (строка) значение для блока контента по умолчанию (псевдоним для content_en). </li>
      <li> title </li>
      <li> description </li>
      <li> alias - (строка) Уникальный псевдоним страницы. </li>
      <li> id - (int) Уникальный идентификатор страницы. </li>
      <li> created_date - (строка date) Дата создания объекта содержимого. </li>
      <li> modified_date - (строка дата) Дата последней модификации объекта содержимого. </li>
      <li> last_modified_by - (int) UID пользователя, который последним изменил страницу. </li>
      <li> owner - (int) UID владельца страницы. </li>
      <li> image - (строка) путь к изображению, связанному со страницей. </li>
      <li> thumbnail - (строка) путь к миниатюре, связанной со страницей. </li>
      <li> extra1 - (строка) значение атрибута extra1. </li>
      <li> extra2 - (строка) значение атрибута extra2. </li>
      <li> extra3 - (строка) значение атрибута extra3. </li>
      <li> pageattr - (строка) значение атрибута данных smarty для конкретной страницы ./li>
    </ul>
    <p> <strong> Примечание. </strong> Приведенный выше список не является исчерпывающим. Вы также можете получить неанализируемое содержимое дополнительных блоков контента или свойств, добавленных сторонними модулями. Вывод всегда представляет собой строку. </p>
  </li>
  <li> <em> (необязательно) </em>  inactive (логический) - разрешает чтение атрибутов неактивных страниц. </li>
  <li> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </li>
</ul>
<h3> Возвращает: </h3>
<p> <strong> строка </strong> - фактическое значение блока содержимого из базы данных для указанного блока и страницы. </p>
<p> <strong> Примечание. </strong> - выходные данные этого плагина не проходят через smarty и не очищаются для отображения. При отображении данных вы должны преобразовать строковые данные и/или передать их через smarty. </p>';
$lang['help_function_page_image'] = '<h3> Для чего это нужно? </h3>
<p> Этот тег можно использовать для получения значения полей изображения или миниатюры определенной страницы. </p>
<h3> Как мне его использовать? </h3>
<p> Вставьте тег в шаблон, например: <code> {page_image} </code>. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
  <li> <em> (необязательно) </em> thumbnail (bool) - отображать значение свойства миниатюры вместо свойства изображения. </li>
  <li> <em> (необязательно) </em> full (bool) - вывести полный URL-адрес изображения относительно пути загрузки изображений. </li>
   <li> <em> (необязательно) </em> tag (bool) - выводить тег полного изображения, если значение свойства не пустое. </li>
  <li> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </li>
</ul>
<h3> Еще ... </h3>
<p> Если аргумент тега включен и значение свойства не пусто, это приведет к выводу полного тега HTML img. Любые аргументы плагина, не указанные выше, будут автоматически включены в результирующий тег img. то есть: <code> {page_image tag = true class = &quot;pageimage&quot; id = &quot;someid&quot; title = &quot;testing&quot;} </code>. </p>
<p> Если плагин выводит полный тег img, а аргумент alt не указан, то значение свойства будет использоваться для атрибута alt тега img. </p>';
$lang['help_function_dump'] = '<h3> Для чего это нужно? </h3>
  <p> Этот тег можно использовать для вывода содержимого любой переменной smarty в более читаемом формате. Это полезно для отладки и редактирования шаблонов, чтобы знать формат и типы доступных данных. </p>
<h3> Как мне его использовать? </h3>
<p> Вставьте тег в шаблон, например <code> {dump item = \'the_smarty_variable_to_dump\'} </code>. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <strong> item (обязательно) </strong> - переменная smarty, содержимое которой нужно выгрузить. </li>
<li> maxlevel - максимальное количество уровней для рекурсии (применимо, только если также указана рекурсия. Значение по умолчанию для этого параметра - 3 </li>
<li> nomethods - пропускать вывод методов  объектов. </li>
<li> novars - пропускать вывод переменных объекта. </li>
<li> recurse - Рекурсия максимального количества уровней через объекты, обеспечивающие подробный вывод для каждого элемента, пока не будет достигнуто максимальное количество уровней. </li>
<li> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </li>
</ul>';
$lang['help_function_content_image'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин позволяет разработчикам шаблонов предлагать пользователям выбрать файл изображения при редактировании содержимого страницы. Он ведет себя аналогично плагину блока контента. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в шаблон страницы, например: <code> {content_image block = \'image1\'} </code>. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
  <li> <strong> (обязательный) </strong> block (строка) - имя этого блока дополнительного содержимого.
    <p> Пример: </p>
    <pre> {content_image block = \'image1\'} </pre> <br/>
  </li>
  <li> <em> (необязательно) </em> label (sring) - метка или название для этого блока контента на странице редактирования контента. Если не указано, будет использовано имя блока. </li>
  <li> <em> (необязательно) </em> dir (строка) - имя каталога (относительно каталога uploads, из которого следует выбирать файлы изображений. Если не указано, будет использоваться данные на странице глобальных настроек. Если эта настройка пуста, будет использоваться каталог uploads.
  <p> Пример: изображения из каталога uploads/images. </p>
  <pre> <code> {content_image block = \'image1\' dir = \'images\'} </code> </pre> <br/>
  </li>
  <li> <em> (необязательно) </em> default (строка) - используется для установки изображения по умолчанию, которое используется, когда изображение не выбрано. </li>
  <li> <em> (необязательно) </em> urlonly (bool) - выводить только URL-адрес изображения, игнорируя все параметры, такие как идентификатор, имя, ширина, высота и т. д. </li>
  <li> <em> (необязательно) </em> tab (string) Желаемая вкладка для отображения этого поля в форме редактирования страницы. </li>
  <li> <em> (необязательно) </em> exclude (строка) - укажите префикс файлов для исключения, например: thumb_ </li>
  <li> <em> (необязательно) </em> sort (bool) - отсортировать параметры. По умолчанию сортировка не выполняется. </li>
  <li> <em> (необязательно) </em> priority (целое число) - позволяет указать целочисленный приоритет для блока на вкладке. </li>
  <li> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </li>
</ul>
<h3> Еще ... </h3>
<p> <strong> Примечание. </strong> Начиная с версии 2.2, если этот блок содержимого не содержит значения, вывод не создается. </p>
<p> В дополнение к аргументам, перечисленным выше, этот плагин будет принимать любое количество дополнительных аргументов и перенаправлять их непосредственно в сгенерированный тег img, если таковой имеется. например: <code> {content_image block = \'img1\' id = &quot;id_img1&quot; class = &quot;page-image&quot; title = \'блок изображения\' data-foo = bar} </code>';
$lang['help_function_process_pagedata'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин будет обрабатывать данные в блоке &quot; Данные или логика Smarty для данной страницы &quot; страниц сайта через Smarty. Он позволяет вам указывать smarty данные, относящиеся к конкретной странице, без изменения шаблона для каждой страницы. </p>
<h3> Как мне его использовать? </h3>
<ol>
   <li> Вставьте smarty переменные и другую smarty логику в поле pagedata на некоторых страницах с контентом. </li>
   <li> Вставьте тег <code> {process_pagedata} </code> в самый верх шаблона страницы. </li>
</ol>
<br/>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_current_date'] = 'Не рекомендуется.';
$lang['help_function_tab_end'] = '<h3> Для чего это нужно? </h3>
   <p> Этот плагин выводит HTML-код для обозначения конца области контента. </p>
<h3> Как мне его использовать? </h3>
<p> Следующий код создает область контента с двумя вкладками. </p>
<pre> <code> {tab_header name = \'tab1\' label = \'Tab One\'}
{tab_header name = \'tab2\' label = \'Tab Two\'}
{tab_start name = \'tab1\'}
&lt;p&gt; Это первая вкладка &lt;/p&gt;
{tab_start name = \'tab2\'}
&lt;p&gt; Это вкладка Два &lt;/p&gt;
<span style = &quot;color: blue;&quot;> {tab_end} </span> </code> </pre>
<h3> Какие параметры он принимает? </h3>
<ul>
    <li> assign - <em> (необязательно) </em> - назначить вывод указанной переменной smarty. </li>
</ul>
<h3> См. также: </h3>
   <ul>
     <li> {tab_header} </li>
     <li> {tab_start} </li>
   </ul>';
$lang['help_function_tab_header'] = '<h3> Для чего это нужно? </h3>
  <p> Этот тег генерирует HTML-код для разделения заголовка одной вкладки в области контента с вкладками. </p>
<h3> Как мне его использовать? </h3>
<p> Следующий код создает область содержимого с вкладками с двумя вкладками. </p>
<pre> <code> <span style = &quot;color: blue;&quot;> {tab_header name = \'tab1\' label = \'Tab One\'} </span>
<span style = &quot;color: blue;&quot;> {tab_header name = \'tab2\' label = \'Tab Two\'} </span>
{tab_start name = \'tab1\'}
&lt;p&gt; Это первая вкладка &lt;/p&gt;
{tab_start name = \'tab2\'}
&lt;p&gt;Это вкладка Два &lt;/p&gt;
{tab_end} </code> </pre>
<p> <strong> Примечание. </strong> <code> {tab_start} </code> должен вызываться с именами в том же порядке, в котором они были предоставлены для <code> {tab_header} </code> </ p >
<h3> Какие параметры он принимает? </h3>
<ul>
   <li> <strong> name - обязательная строка </strong> - название вкладки. Должно совпадать с названием вкладки, переданной в {tab_header} </li>
   <li> label - <em> необязательная строка </em> - удобочитаемая метка вкладки. Если не указано иное, будет использовано имя вкладки. </li>
   <li> active - <em> необязательно, смешанный </em> - указывает, активна это вкладка или нет. Вы можете передать имя (строку) активной вкладки в последовательности заголовков вкладок или логическое значение. </li>
   <li> assign - <em> (необязательно) </em> - назначить вывод указанной переменной smarty. </li>
</ul>
<h3> См. также: </h3>
  <ul>
    <li> {tab_start} </li>
    <li> {tab_end} </li>
  </ul>';
$lang['help_function_tab_start'] = '<h3> Для чего это нужно? </h3>
  <p> Этот плагин предоставляет html-код для ограничения начала содержимого для определенной вкладки в области содержимого с вкладками. </p>
<h3> Как мне его использовать? </h3>
<p> Следующий код создает область содержимого с вкладками с двумя вкладками. </p>
<pre> <code> {tab_header name = \'tab1\' label = \'Tab One\'}
{tab_header name = \'tab2\' label = \'Tab Two\'}
<span style = &quot;color: blue;&quot;> {tab_start name = \'tab1\'} </span>
&lt;p&gt; Это первая вкладка &lt;/p&gt;
<span style = &quot;color: blue;&quot;> {tab_start name = \'tab2\'} </span>
&lt;p&gt; Это вкладка Два &lt;/p&gt;
{tab_end} </code> </pre>
<p> <strong> Примечание. </strong> <code> {tab_start} </code> должен вызываться с именами в том же порядке, в котором они были предоставлены для <code> {tab_header} </code> </ p >
<h3> Какие параметры он принимает? </h3>
<ul>
   <li> <strong> name - обязательно </strong> - название вкладки. Должно совпадать с названием вкладки, переданной в {tab_header} </li>
   <li> assign - <em> (необязательно) </em> - назначить вывод указанной переменной smarty. </li>
</ul>
<h3> См. также: </h3>
  <ul>
    <li> {tab_header} </li>
    <li> {tab_end} </li>
  </ul>';
$lang['help_function_title'] = '<h3> Для чего это нужно? </h3>
<p> Выводить заголовок страницы. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон/страницу, например: <code>{title}</code> </p>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_stylesheet'] = 'Не рекомендуется. Смотрите cms_stylesheet.';
$lang['help_function_sitename'] = '<h3> Для чего это нужно? </h3>
<p> Показывает название сайта. Определяется во время установки и может быть изменён в разделе «Глобальные настройки» панели администратора. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон/страницу, например: <code>{sitename}</code> </p>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_search'] = '<h3> Для чего это нужно? </h3>
<p> На самом деле это просто тег-оболочка для модуля поиска, упрощающий синтаксис тега.
Вместо использования <code> {cms_module module = \'Search\'} </code> теперь вы можете просто использовать <code> {search} </code> для вставки модуля в шаблон.
</p>
<h3> Как мне его использовать? </h3>
<p> Просто поместите <code> {search} </code> в шаблон там, где вы хотите, чтобы появилось поле ввода поиска. Для получения справки о модуле поиска см. Справку модуля поиска. </p>';
$lang['help_function_cms_textarea'] = '<h3> Для чего это нужно? </h3>
  <p> Этот smarty плагин используется в админке для создания html тега textarea. Он имеет различные параметры, которые позволяют контролировать, используется ли плагин визуального редактора WYSIWYG <em> (если доступно) </em> или подсветка синтаксиса, а также для влияния на поведение этих модулей, а также размер и внешний вид текстового поля. </ P >
  <h3> Как мне его использовать? </h3>
    <p> Самый простой способ использовать этот плагин - указать <code> {cms_textarea name = &quot; something &quot;} </code>. Это создаст простую текстовую область без включенных модулей WYSIWYG или подсветки синтаксиса с указанным именем. </p>
    <p> Затем вы можете указать значение по умолчанию для текстовой области, используя &quot;text&quot; или &quot;value&quot; параметры. </p>
  <h3> Какие параметры он принимает? </h3>
  <ul>
    <li> name - обязательная строка: атрибут name для textarea. </li>
    <li> prefix - необязательная строка: необязательный префикс для атрибута name. </li>
    <li> class - необязательный атрибут string: class для элемента текстовой области. Дополнительные классы могут добавляться автоматически. </li>
    <li> classname - псевдоним для параметра класса. </li>
    <li> forcemodule - необязательная строка: используется для указания модуля подсветки синтаксиса или WYSIWYG для включения. Если указано и доступно, имя модуля будет добавлено в атрибут класса. </li>
    <li> enablewysiwyg - необязательное логическое значение: используется для указания, требуется ли в текстовом поле визуальный редктор WYSIWYG. </li>
    <li> wishsyntax - необязательная строка, используемая для указания используемого языка (html, css, php, smarty ...). Если не пусто, значит, запрошен модуль подсветки синтаксиса. </li>
    <li> type - псевдоним для параметра wishsyntax. </li>
    <li> cols - необязательное целое число: столбцы текстовой области (css темы администратора или модуль синтаксиса / WYSIWYG могут переопределить это). </li>
    <li> width - псевдоним для параметра cols. </li>
    <li> rows - необязательное целое число: строки текстовой области (css темы администратора или модуль синтаксиса / WYSIWYG могут переопределить это). </li>
    <li> height - псевдоним для параметра rows. </li>
    <li> maxlength - необязательный атрибут integer: maxlength текстовой области (модуль синтаксиса / WYSIWYG может игнорировать это). </li>
    <li> required - необязательное логическое значение: указывает на обязательное заполнение поля. </li>
    <li> placeholder - необязательная строка: атрибут placeholder текстовой области (синтаксис / модуль WYSIWYG может игнорировать это). </li>
    <li> value - необязательная строка: текст по умолчанию для текстовой области будет преобразован в сущность. </li>
    <li> text - псевдоним для параметра value </li>
    <li> cssname - необязательная строка: передаёт имя таблицы стилей в модуль WYSIWYG, если модуль WYSIWYG включен. </li>
    <li> addtext - необязательная строка: дополнительный текст для добавления к тегу textarea. </li>
    <li> assign - необязательная строка: присвоить выходной HTML-код указанной переменной smarty. </li>
  </ul>';
$lang['help_function_root_url'] = '<h3> Для чего это нужно? </h3>
<p> Печатает корневой URL-адрес сайта. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон/страницу, например: <code>{root_url}</code> </p>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) autossl = 1 </em> - включен по умолчанию, этот параметр определяет, был ли запрос, сделанный на сервер, через SSL, и был ли он возвращен соответствующим образом настроенным URL-адресом SSL. Чтобы отключить эту функцию, укажите autossl = 0. </p>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_repeat'] = '<h3> Для чего это нужно? </h3>
   <p> Повторяет указанную последовательность символов указанное количество раз </p>
   <h3> Как мне его использовать? </h3>
   <p> Вставьте тег, подобный следующему, в свой шаблон/страницу, например: <code> {repeat string = \'repeat this\' times = \'3\'} </code> </p>
   <h3> Какие параметры он принимает? </h3>
   <ul>
   <li> string = \'text\' - строка, которую нужно повторить. </li>
   <li> times = \'num\' - количество повторений. </li>
   <li> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </li>
   </ul>';
$lang['help_function_recently_updated'] = '<h3> Для чего это нужно? </h3>
<p> Выводит список недавно обновленных страниц. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон/страницу, например: <code>{recently_updated}</code> </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li><p> <em> (необязательно) </em> number = \'10 \'- количество обновленных страниц для отображения. </p> <p> Пример: {Recent_updated number = \'15\'} </p> </li>
 <li><p> <em> (необязательно) </em> leadin = \'Последнее изменение\' - текст, отображаемый слева от даты изменения. </p> <p> Пример: {Recent_updated leadin = \'Last Changed\'} </p> </li>
 <li><p> <em> (необязательно) </em> showtitle = \'true\' - показывает атрибут заголовка, если он тоже существует (true | false). </p> <p> Пример: {Recent_updated showtitle = \'true\'} </p> </li>
<li><p> <em> (необязательно) </em> css_class = \'some_name\' - добавить тег div с этим классом вокруг списка. </p> <p> Пример: {Recent_updated css_class = \'some_name\'} </p> </li>
<li><p> <em> (необязательно) </em> dateformat = \'\'d.m.y h:m\' - по умолчанию d.m.y h:m, используйте желаемый формат (php-date-format) </p> <p > Пример: {Recent_updated dateformat = \'D M j G:i:s T Y\'} </p> </li>
<li> <em> (необязательно) </em> <tt> assign </tt> - присвоить результаты переменной smarty. </li>
</ul>
<p> или комбинированный: </p>
<pre> {Recent_updated number = \'15\' showtitle =\'false\' leadin =\'Последнее изменение:\' css_class =\' ​​my_changes\' dateformat =\'D M j G:i:s T Y\'} </pre>';
$lang['help_function_print'] = '<h3> Для чего это нужно? </h3>
<p> На самом деле это просто тег-обёртка для модуля CMSPrinting, упрощающий синтаксис тега.
Вместо использования <code> {cms_module module = \'CMSPrinting\'} </code> теперь вы можете просто использовать <code> {print} </code> для вставки модуля на страницы и в шаблоны.
</p>
<h3> Как мне его использовать? </h3>
<p> Просто поместите <code> {print} </code> на страницу или в шаблон. Чтобы получить справку о модуле CMSPrinting, его параметрах и т. Д., Обратитесь к справке модуля CMSPrinting. </p>';
$lang['help_function_news'] = '<h3> Для чего это нужно? </h3>
<p> На самом деле это просто тег-обёртка для модуля новостей, упрощающий синтаксис тега.
Вместо использования <code> {cms_module module = \'News\'} </code> теперь вы можете просто использовать <code> {news} </code> для вставки модуля на страницы и в шаблоны.
</p>
<h3> Как мне его использовать? </h3>
<p> Просто поместите <code> {news} </code> на страницу или в шаблон. Чтобы получить справку о модуле новостей, его параметрах и т. д., обратитесь к справке модуля новостей. </p>';
$lang['help_function_modified_date'] = '<h3> Для чего это нужно? </h3>
         <p> Печатает дату и время последнего изменения страницы. Если формат не указан, по умолчанию будет выбран формат, аналогичный «01 января 2004 г.». </p>
         <h3> Как мне его использовать? </h3>
         <p> Просто вставьте тег в свой шаблон/страницу, например: <code> {modified_date format = &quot;%A %d-%b-%y %T %Z&quot;} </code> </p>
         <h3> Какие параметры он принимает? </h3>
         <ul>
                 <li> <em> (необязательно) </em> format - формат даты/времени с использованием параметров из функции php strftime. См. <a href=&quot;http://php.net/strftime&quot; target=&quot;_blank&quot;> здесь </a> для получения списка параметров и информации. </li>
                 <li> <em> (необязательно) </em> assign - присвоить результаты названной переменной smarty. </li>
         </ul>';
$lang['help_function_metadata'] = '<h3> Для чего это нужно? </h3>
<p> Отображает метаданные для этой страницы. Будут показаны как глобальные метаданные со страницы глобальных настроек, так и метаданные для каждой страницы. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон, например: <code>{metadata}</code> </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <em> (необязательно) </em> showbase (true / false) - если установлено значение false, базовый тег не выводится. </li>
<li> <em> (необязательно) </em> <tt> assign </tt> - присвоить результаты названной переменной smarty. </li>
</ul>';
$lang['help_function_menu_text'] = '<h3> Для чего это нужно? </h3>
<p> Печатает текст меню страницы. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон / страницу, например: <code>{menu_text}</code> </p>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_menu'] = '<h3> Для чего это нужно? </h3>
<p> На самом деле это просто тег-оболочка для модуля Менеджера меню, упрощающий синтаксис тега.
Вместо использования <code> {cms_module module = \'MenuManager\'} </code> теперь вы можете просто использовать <code> {menu} </code> для вставки модуля на страницы и в шаблоны.
</p>
<h3> Как мне его использовать? </h3>
<p> Просто поместите <code> {menu} </code> на страницу или в шаблон. Для получения справки о модуле меню, его параметрах и т. Д. Обратитесь к справке модуля меню. </p>';
$lang['help_function_last_modified_by'] = '<h3> Для чего это нужно? </h3>
         <p> Вывод последнего пользователя, редактировавшего эту страницу. Если формат не указан, по умолчанию используется идентификационный номер пользователя. </p>
         <h3> Как мне его использовать? </h3>
         <p> Просто вставьте тег в свой шаблон / страницу, например: <code> {last_modified_by format = &quot;fullname&quot;} </code> </p>
         <h3> Какие параметры он принимает? </h3>
         <ul>
                 <li> <em> (необязательно) </em> format - идентификатор, имя пользователя, полное имя </li>
<li> <em> (необязательно) </em> <tt> assign </tt> - присвоить результаты названной переменной smarty. </li>
         </ul>';
$lang['help_function_image'] = 'Этот плагин не рекомендуется к использованию.';
$lang['help_function_html_blob'] = '<h3> Для чего это нужно? </h3>
<p> См. описание в справке по global_content. </p>';
$lang['help_function_google_search'] = '<h3> Для чего это нужно? </h3>
<p> Найдите свой веб-сайт с помощью поисковой системы Google. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон / страницу, например: <code> {google_search} </code> <br />
<br />
Примечание. Google должен проиндексировать ваш веб-сайт, чтобы это работало. Вы можете отправить свой веб-сайт в Google <a href=&quot;http://www.google.com/addurl.html&quot;> здесь </a>. </p>
<h3> Что, если я хочу изменить внешний вид текстового поля или кнопки? </h3>
<p> Внешний вид текстового поля и кнопки можно изменить с помощью CSS. Текстовому полю дается идентификатор textSearch, а кнопке - идентификатор buttonSearch. </p>

<h3> Какие параметры он принимает? </h3>
<ul>
<li> <em> (необязательно) </em> domain - указывает Google домен веб-сайта для поиска. Этот плагин пытается определить это автоматически. </li>
<li> <em> (необязательно) </em> buttonText - текст, который нужно отображать на кнопке поиска. По умолчанию используется &quot;Поиск по сайту&quot;. </li>
<li> <em> (необязательно) </em> <tt> assign </tt> - присвоить результаты названной переменной smarty. </li>
</ul>';
$lang['help_function_global_content'] = '<h3> Для чего это нужно? </h3>
<p> Вставляет глобальный блок содержимого в ваш шаблон или страницу. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон / страницу, например: <code> {global_content name = \'myblock\'} </code>, где name - это имя, присвоенное блоку при его создании. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
   <li> name - имя отображаемого глобального блока содержимого. </li>
           <li> <em> (необязательно) </em> assign - имя переменной smarty, которой должен быть назначен глобальный блок содержимого. </li>
</ul>';
$lang['help_function_get_template_vars'] = '<h3> Для чего это нужно? </h3>
<p> Сбрасывает все известные переменные smarty на вашу страницу </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон / страницу, например: <code>{get_template_vars}</code> </p>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_page_error'] = '<h3> Для чего это нужно? </h3>
<p> Это плагин отображает ошибку на странице в панели администратора CMSMS. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
   <li> msg - <strong> обязательная строка </strong> - отображаемое сообщение об ошибке. </li>
   <li> assign - <em> (необязательно) </em> - назначить вывод указанной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
<pre> <code> {page_error msg = \'Ошибка обнаружена\'} </code> </pre>';
$lang['help_function_page_warning'] = '<h3> Для чего это нужно? </h3>
<p> Это плагин отображает предупреждение на странице панели администратора CMSMS. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
   <li> msg - <strong> обязательная строка </strong> - отображаемое предупреждающее сообщение. </li>
   <li> assign - <em> (необязательно) </em> - назначить вывод указанной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
<pre> <code> {page_warning msg = \'Что-то пахнет рыбой\'} </code> </pre>';
$lang['help_function_uploads_url'] = '<h3> Для чего это нужно? </h3>
<p> Выводит URL-адрес загрузки для сайта. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон / страницу, например: <code>{uploads_url}</code> </p>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_embed'] = '<h3> Для чего это нужно? </h3>
<p> Разрешить включение (встраивание) любого другого приложения в CMS. Например это может быть форум.Эта реализация использует теги IFRAMES, поэтому в старых браузерах могут возникать проблемы. Это единственный известный способ который работает без изменения встроенного приложения. </p>
<h3> Как мне его использовать? </h3>
        <ul>
        <li> а) Добавьте <code> {embed header = true} </code> в раздел заголовка шаблона страницы или в раздел метаданных на вкладке параметров страницы с контентом. Это обеспечит включение необходимого JavaScript. Если вы вставляете этот тег в раздел метаданных на вкладке параметров страницы вы должны убедиться, что <code> {metadata} </code> присутствует в шаблоне страницы. </li>
        <li> б) Добавьте <code> {embed url = &quot;http://www.google.com&quot;} </code> в содержание своей страницы или в основной текст шаблона страницы. </li>
        </ul>
        <br/>
        <h4> Пример увеличения размера окна iframe </h4>
<p> Добавьте в свою таблицу стилей следующее: </p>
        <pre> #myframe {высота: 600 пикселей; } </pre>
        <br/>
        <h3> Какие параметры он принимает? </h3>
        <ul>
            <li> <em> (обязательно) </em> url - URL, который будет включен </li>
            <li> <em> (обязательно) </em> header = true - это будет генерировать код заголовка для правильного изменения размера тега IFRAME. </li>
            <li> (необязательно) name - необязательное имя для использования в iframe (вместо myframe). <p> Если этот параметр используется, он должен использоваться одинаково в обоих вызовах, то есть: {embed header = true name = foo} и {embed name = foo url = http: //www.google.com}. </p> </li>
        </ul>';
$lang['help_function_description'] = '<h3> Для чего это нужно? </h3>
<p> Выводит мета-тег description страницы. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон / страницу, например: <code>{description}</code> </p>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_created_date'] = '<h3> Для чего это нужно? </h3>
         <p>Выводит дату и время создания страницы. Если формат не указан, по умолчанию будет выбран формат, аналогичный «01 января 2004 г.». </p>
         <h3> Как мне его использовать? </h3>
         <p> Просто вставьте тег в свой шаблон / страницу, например: <code> {created_date format = &quot;%A %d-%b-%y %T %Z&quot;} </code> </p>
         <h3> Какие параметры он принимает? </h3>
         <ul>
                 <li> <em> (необязательно) </em> format - формат даты / времени с использованием параметров из функции php strftime. См. <a href=&quot;http://php.net/strftime&quot; target=&quot;_blank&quot;> здесь </a> для получения списка параметров и информации. </li>
                 <li> <em> (необязательно) </em> assign - присвоить результаты названной переменной smarty. </li>
         </ul>';
$lang['help_function_content'] = '<h3> Для чего это нужно? </h3>
<p> Этот тег выводит содержимое вашей страницы. Он вставляется в шаблон и изменяется в зависимости от отображаемой страницы. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон, например: <code> {content} </code>. </p>
<p> <strong> Блок по умолчанию <code> {content} </code> необходим в шаблоне. </strong> Чтобы присвоить блоку конкретную метку, используйте параметр label. Дополнительные блоки можно добавить с помощью параметра block. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <em> (необязательно) </em> block - позволяет иметь более одного блока контента на странице. Когда в шаблон помещено несколько тегов контента, это количество полей редактирования будет отображаться в редакторе страницы.
<p> Пример: </p>
<pre> {content block = &quot;second_content_block&quot; label = &quot;Второй блок контента&quot;} </pre>
<p> Теперь, когда вы редактируете страницу, появляется текстовое поле под названием «Второй блок контента». </p> </li>
<li> <em> (необязательно) </em> wysiwyg (true / false) - если установлено значение false, WYSIWYG-редктор никогда не будет использоваться при редактировании этого блока. Работает только при использовании параметра блока. </li>
<li> <em> (необязательно) </em> oneline (true / false) - если установлено значение true, при редактировании этого блока будет отображаться только одна строка редактирования. Если false, то текстовое поле. Работает только при использовании параметра блока. </li>
        <li> <em> (необязательно) </em> size (положительное целое число). Применимо только при использовании однострочного параметра. Этот необязательный параметр позволяет указать размер поля редактирования. Значение по умолчанию - 50. </li>
<li> <em> (необязательно) </em> maxlength (положительное целое число) - применимо только при использовании опции oneline. Этот необязательный параметр позволяет указать максимальную длину ввода для поля редактирования. Значение по умолчанию - 255. </li>
        <li> <em> (необязательно) </em> default (строка) - позволяет указать содержимое по умолчанию для этих блоков контента (только для дополнительных блоков). </li>
<li> <em> (необязательно) </em> label (string) - позволяет указать метку для отображения на странице редактирования контента. </li>
        <li> <em> (необязательно) </em> required (true / false) - позволяет указать, что блок содержимого должен содержать некоторый текст. </li>
        <li> <em> (необязательно) </em> placeholder (строка) - позволяет указать текст заполнителя. </li>
        <li> <em> (необязательно) </em> priority (целое число) - позволяет указать целочисленный приоритет для блока на вкладке. </li>
        <li> <em> (необязательно) </em> tab (строка) - желаемая вкладка для отображения этого поля в форме редактирования. </li>
        <li> <em> (необязательно) </em> cssname (строка) - подсказка модулю редактора WYSIWYG использовать указанное имя таблицы стилей для расширенных стилей. </li>
        <li> <em> (необязательно) </em> noedit (true / false) - если установлено значение true, блок контента не будет доступен для редактирования в форме редактирования контента. Это полезно для вывода блока на страницы, созданные с помощью стороннего модуля. </li>
        <li> <em> (необязательно) </em> data-xxxx (строка) - разрешает передачу атрибутов данных в сгенерированное текстовое поле для использования модулями синтаксиса hilighter и WYSIWYG.
            <p> то есть: <code> {content data-foo = &quot;bar&quot;} </code> </p>
        </li>
        <li> <em> (необязательно) </em> adminonly (true / false) - если задано значение true, только члены специального &quot;Admin&quot;; group (gid == 1) смогут редактировать этот блок контента. </li>
<li> <em> (необязательно) </em> assign - присваивает контент параметру smarty, который затем можно использовать в других областях страницы или использовать для проверки того, существует ли в нем контент или нет.
<p> Пример передачи контента страницы в пользовательский тег в качестве параметра: </p> </li>
<pre>
         {content assign = pagecontent}
         {table_of_contents thepagecontent = $pagecontent}
</pre>
</li>
</ul>';
$lang['help_function_contact_form'] = 'Не рекомендуется. Используйте модуль FormBuilder.';
$lang['help_function_cms_versionname'] = '<h3> Для чего это нужно? </h3>
<p> Этот тег используется для вставки названия текущей версии CMS в ваш шаблон или страницу. Он не отображает ничего, кроме названия версии. </p>
<h3> Как мне его использовать? </h3>
<p> Это просто основной плагин тегов. Вы должны вставить его в свой шаблон или страницу следующим образом: <code> {cms_versionname} </code>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_cms_version'] = '<h3> Для чего это нужно? </h3>
<p> Этот тег используется для вставки текущего номера версии CMS в ваш шаблон или страницу. Он не отображает ничего, кроме номера версии. </p>
<h3> Как мне его использовать? </h3>
<p> Это просто основной плагин тегов. Вы должны вставить его в свой шаблон или страницу следующим образом: <code>{cms_version}</code> </p>
<h3> Какие параметры он принимает? </h3>
<p> <em> (необязательно) </em> assign (string) - присвоить результаты переменной smarty с этим именем. </p>';
$lang['help_function_cms_selflink'] = '<h3> Для чего это нужно? </h3>
<p> Создает ссылку на другую страницу контента CMSMS внутри шаблона или контента страницы. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон/страницу, например: <code> {cms_selflink page = &quot;1&quot;} </code> или <code> {cms_selflink page = &quot; alias &quot;} </code> </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <em> (необязательно) </em> <tt> page </tt> - идентификатор страницы или псевдоним, на который нужно ссылаться. </li>
<li> <em> (необязательно) </em> <tt> anchorlink </tt> - указывает привязку для добавления к сгенерированному URL-адресу. </li>
<li> <em> (необязательно) </em> <tt> urlparam </tt> - укажите дополнительные параметры для URL-адреса. <strong> Не используйте это вместе с параметром <em> anchorlink </em> </strong> </li>
<li> <em> (необязательно) </em> <tt> tabindex = &quot; значение &quot; </tt> - установить индекс табуляции для ссылки. </li>
<li> <em> (необязательно) </em> <tt> dir start / next / prev / up (previous) </tt> - ссылки на стартовую страницу по умолчанию, следующую или предыдущую страницу или родительскую страницу (вверх). Если это используется, <tt> page </tt> не следует устанавливать. </li>
</ul>
<strong> Примечание! </strong> В одном операторе cms_selflink можно использовать только один из вышеперечисленных параметров!!
<ul>
<li> <em> (необязательно) </em> <tt> text </tt> - текст, отображаемый для ссылки. Если не указано, вместо него используется имя страницы. </li>
<li> <em> (необязательно) </em> <tt> menu 1/0 </tt> - если 1, текст меню используется для текста ссылки вместо имени страницы. </li>
<li> <em> (необязательно) </em> <tt> target </tt> - цель, на которую указывает ссылка. Полезно для фреймов и JavaScript. </li>
<li> <em> (необязательно) </em> <tt> class </tt> - css класс. Полезно для стилизации ссылки. </li>
<li> <em> (необязательно) </em> <tt> id </tt> - необязательный css id для тега &lt;a&gt;. </li>
<li> <em> (необязательно) </em> <tt> more </tt> - разместите дополнительные параметры внутри тега &lt;a&gt;. </li>
<li> <em> (необязательно) </em> <tt> label </tt> - метка для использования со ссылкой, если применимо. </li>
<li> <em> (необязательно) </em> <tt> label_side left / right </tt> - сторона ссылки для размещения метки (по умолчанию &quot;left&quot;). </li>
<li> <em> (необязательно) </em> <tt> title </tt> - текст для использования в атрибуте заголовка. Если ничего не указано, в качестве заголовка будет использоваться заголовок страницы. </li>
<li> <em> (необязательно) </em> <tt> rellink 1/0 </tt> - создайте реляционную ссылку для доступной навигации. Работает только в том случае, если установлен параметр dir и должен находиться только в разделе заголовка шаблона. </li>
<li> <em> (необязательно) </em> <tt> href </tt> - указывает, что будет возвращен только URL результата для указанного псевдонима страницы. По сути это равно {cms_selflink page = &quot;alias&quot; urlonly = 1}. <strong> Пример: </strong> &lt;a href=&quot;{cms_selflink href =&quot;alias&quot;}&quot; &gt; &lt; img src = &quot;&quot; &quot;&gt; &lt;/a&gt;. </li>
<li> <em> (необязательно) </em> <tt> urlonly </tt> - указывает, что должен выводиться только результирующий URL. Все параметры, связанные с созданием ссылок, игнорируются. </li>
<li> <em> (необязательно) </em> <tt> image </tt> - URL-адрес изображения для использования в ссылке. <strong> Пример: </strong> {cms_selflink dir = &quot;next&quot; image = &quot;next.png&quot; text = &quot;Далее&quot;} </li>
<li> <em> (необязательно) </em> <tt> alt </tt> - альтернативный текст, который будет использоваться с изображением (alt = &quot;&quot; будет использоваться, если не указан параметр alt). </li>
<li> <em> (необязательно) </em> <tt> width </tt> - ширина, которая будет использоваться с изображением (атрибут ширины не будет использоваться в выходном теге img, если не указан). </li>
<li> <em> (необязательно) </em> <tt> height </tt> - высота, которая будет использоваться с изображением (атрибут высоты не будет использоваться в выходном теге img, если не указан). </li>
<li> <em> (необязательно) </em> <tt> imageonly </tt> - при использовании изображения следует ли подавлять отображение текстовых ссылок. Если вы не хотите, чтобы в ссылке вообще не было текста, также установите lang = 0, чтобы скрыть метку. <strong> Пример: </strong> {cms_selflink dir = &quot;next&quot; image = &quot;next.png&quot; text = &quot;Далее&quot; imageonly = 1} </li>
        <li> <em> (необязательно) </em> <tt> assign </tt> - присвоить результаты названной переменной smarty. </li>
</ul>';
$lang['help_function_cms_module'] = '<h3> Для чего это нужно? </h3>
<p> Этот тег используется для вставки модулей в ваши шаблоны и страницы. Если модуль создан для использования в качестве подключаемого модуля тега (подробности см. В справке), вы сможете вставить его с помощью этого тега. </p>
<h3> Как мне его использовать? </h3>
<p> Это просто базовый плагин для тегов. Вы должны вставить его в свой шаблон или страницу следующим образом: <code> {cms_module module = &quot;somemodulename&quot;} </code> </p>
<h3> Какие параметры он принимает? </h3>
<p> Обязательный параметр только один. Все остальные параметры передаются модулю. </p>
<ul>
<li> module - Имя вставляемого модуля. Регистр не учитывается. </li>
</ul>';
$lang['help_function_cms_module_hint'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин можно использовать для передачи параметров в модуль, если в URL-адресе нельзя указать нужные параметры. То есть: в ситуации, когда сайт настроен на использование ЧПУ для целей SEO, часто невозможно предоставить дополнительные параметры модуля, такие как используемый шаблон или порядок сортировки в URL-адресе. Этот плагин можно использовать в шаблонах страниц, GCB или в зависимости от страницы, чтобы давать подсказки относительно того, как модули должны себя вести. </p>
<p> <strong> Примечание. </strong> Любые параметры, указанные в URL-адресе, имеют приоритет перед соответствующими параментами модуля. То есть: при использовании тега News вместе с параметром detailtemplate и указанни detailtemplate в URL-адресе, параметр detailtemplate не будут учитываться. </p>
<p> <strong> Примечание. </strong> Для обеспечения надлежащего поведения модуля параметы должны быть переданы до выполнения тега {content} в шаблоне страницы CMSMS. Следовательно, они должны (обычно) создаваться очень рано в процессе создания шаблона страницы. Идеальное место для конкретной страницы - это поле Данные или логика Smarty, относящиеся к этой странице: textarea в форме редактирования контента. </p>
<h3> Параметры: </h3>
<ul>
  <li> module - <strong> обязательная строка </strong> - имя модуля, для которого вы передаёте параметр.</i>
</ul>
<p> Любые другие параметры этого тега сохраняются как подсказки. </p>
<h3> Пример: </h3>
<p> При использовании модуля новостей настраиваются ЧПУ. Вы хотите отображать новостные статьи для определенной категории на одной странице и хотели бы использовать нестандартный шаблон новости для отображения отдельных статей на другой странице. То есть: возможно, на вашем &quot;Sports&quot; Страница, которую вы вызываете Новости, например: <code> {News category=sports detailpage=sports_detail} </code>. Однако при использовании ЧПУ может оказаться невозможным указать шаблон подробностей для ссылок, которые будут генерировать подробные представления. Решение состоит в том, чтобы использовать тег {cms_module_hint} на странице <u>sports_detail</u>, чтобы дать некоторые подсказки относительно того, как Новости должны вести себя на этой странице. </p>
<p> При редактировании страницы <u>sports_detail</u> на вкладке параметров в текстовой области под названием &quot;Данные или логика Smarty, относящиеся к этой странице:&quot; вы можете ввести такой тег: <code>{cms_module_hint module=News detailtemplate=sports} </code>. Теперь, когда пользователь нажимает ссылку в сводке новостей на странице &quot;sports&quot; он будет направлен на страницу <u>sports_detail</u>, а также на подробный шаблон новостей под названием &quot;sports&quot; будет использоваться для отображения статьи. </p>
<h3> Использование: </h3>
<p> <code> {cms_module_hint module=ModuleName paramname=value ...} </code> </p>
<p> <strong> Примечание. </strong> Можно указать несколько подсказок параметров для одного модуля за один вызов этого плагина. </p>
<p> <strong> Примечание. </strong> Этот модуль можно вызывать несколько раз, чтобы предоставить подсказки для разных модулей. </p>';
$lang['help_function_breadcrumbs'] = 'УДАЛЕНО - используйте сейчас {nav_breadcrumbs} или {Navigator action = \'breadcrumbs\'}';
$lang['help_function_anchor'] = '<h3> Для чего это нужно? </h3>
<p> Создает правильную якорную ссылку. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте тег в свой шаблон / страницу, например: <code> {anchor anchor=\'here\' text=\'Scroll Down\'} </code> </p>
<h3> Какие параметры он принимает? </h3>
<ul>
<li> <tt> anchor </tt> - где мы делаем ссылку. Часть после #. </li>
<li> <tt> text </tt> - текст, отображаемый в ссылке. </li>
<li> <tt> class </tt> - класс для ссылки, если есть </li>
<li> <tt> title </tt> - заголовок, отображаемый для ссылки, если таковой имеется. </li>
<li> <tt> tabindex </tt> - числовой tabindex для ссылки, если таковой имеется. </li>
<li> <tt> accesskey </tt> - ключ доступа для ссылки, если есть. </li>
<li> <em> (необязательно) </em> <tt> onlyhref </tt> - отображать только href, а не всю ссылку. Никакие другие варианты не будут работать </li>
<li> <em> (необязательно) </em> <tt> assign </tt> - присвоить результаты названной переменной smarty. </li>
</ul>';
$lang['help_function_site_mapper'] = '<h3> Для чего это нужно? </h3>
   <p> На самом деле это просто тег-обёртка для модуля Менеджера меню, чтобы упростить синтаксис тега и упростить создание карты сайта. </p>
<h3> Как мне его использовать? </h3>
   <p> Просто поместите <code> {site_mapper} </code> на страницу или в шаблон. Для получения справки о модуле диспетчера меню, его параметрах и т. д. Обратитесь к справке модуля диспетчера меню. </p>
   <p> По умолчанию, если параметр шаблона не указан, будет использоваться файл minimal_menu.tpl. </p>
   <p> Любые параметры, используемые в теге, доступны в шаблоне menumanager как <code>{$menuparams.paramname}</code> </p>';
$lang['help_function_redirect_url'] = '<h3> Для чего это нужно? </h3>
   <p> Этот плагин позволяет легко перенаправлять на указанный URL. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте этот тег на свою страницу или шаблон: <code> {redirect_url to=\'http: //www.cmsmadesimple.org\'} </code> </p>';
$lang['help_function_redirect_page'] = '<h3> Для чего это нужно? </h3>
  <p> Этот плагин позволяет легко перенаправлять на другую страницу. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте этот тег на свою страницу или в шаблон: <code> {redirect_page page=\'some-page-alias\'} </code> </p>';
$lang['help_function_cms_jquery'] = '<h3> Для чего это нужно? </h3>
 <p> Этот плагин позволяет выводить используемые библиотеки и плагины JavaScript в шаблоне. </p>
<h3> Как мне его использовать? </h3>
<p> Просто вставьте этот тег на свою страницу или в шаблон: <code>{cms_jquery}</code> </p>

<h3> Образец </h3>
<pre> <code> {cms_jquery cdn=\'true\' exclude=\'jquery-ui\' append=\'uploads/NCleanBlue/js/ie6fix.js\' include_css=0} </code> </pre>
<h4><em> Вывод:</em> </h4>
<pre> <code>&lt;script type = &quot;text/javascript&quot; src=&quot;https://ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js&quot;&gt;&lt;/script&gt;
&lt;script type = &quot;text/javascript&quot; src=&quot;https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.21/jquery-ui.min.js&quot;&gt;&lt;/script&gt; &lt;script type=&quot;text/javascript&quot; src=&quot;http://localhost/1.10.x/lib/jquery/js/jquery.json-2.3.js&quot; &gt;&lt;/script&gt;
&lt;script type=&quot;text/javascript&quot; src=&quot;uploads/NCleanBlue/js/ie6fix.js&quot; &gt;&lt;/script&gt;</code> </pre>

<h3> Известные скрипты: </h3>
<ul>
<li><tt>jQuery</tt> </li>
<li><tt>jQuery-UI</tt> </li>
<li><tt>nestedSortable</tt> </li>
<li><tt>json</tt> </li>
<li><tt>migrate</tt> </li>
</ul>

<h3> Какие параметры он принимает? </h3>
<ul>
<li> <em> (необязательно) </em> <tt> exclude </tt> - список скриптов, разделенных запятыми (CSV), которые вы хотите исключить. <code>\'jquery-ui,migrate\'</code> </li>
<li> <em> (необязательно) </em> <tt> append </tt> - используйте список значений, разделенных запятыми (CSV), для путей скриптов, которые вы хотите добавить. <code>\'/uploads/jquery.ui.nestedSortable.js,http://code.jquery.com/jquery-1.7.1.min.js\'</code> </li>
<li> <em> (необязательно) </em> <tt> cdn </tt> - cdn = \'true\' вставит jQuery и jQueryUI Frameworks с помощью Google Content Delivery Netwok. По умолчанию - false. </li>
<li> <em> (необязательно) </em> <tt> ssl </tt> - используйте для использования ssl_url в качестве базового пути. </li>
<li> <em> (необязательно) </em> <tt> custom_root </tt> - используйте для установки любого желаемого базового пути. <code> custom_root=\'http://test.domain.com/\' </ code > <br/> ПРИМЕЧАНИЕ: перезаписывает параметр ssl и работает с параметром cdn. </li>
<li> <em> (необязательно) </em> <tt> include_css <em>(boolean)</em> </tt> - используйте для предотвращения включения css в вывод. Значение по умолчанию - истина. </li>
<li> <em> (необязательно) </em> <tt> assign </tt> - присвоить результаты названной переменной smarty. </li>
</ul>';
$lang['help_function_cms_filepicker'] = '<h3> Для чего это нужно? </h3>
<p> Этот плагин создаст поле ввода, которое контролируется модулем выбора файлов, чтобы можно было выбрать файл. Этот плагин только для панели администратора, используется для шаблонов модулей и других административных форм. </p>
<p> Этот плагин следует использовать в шаблоне администратора модуля, а вывод, созданный при выборе файла, должен обрабатываться обычным образом в файле php модуля. </p>
<p> Примечание. Этот плагин обнаружит (используя внутренние механизмы) предпочтительный в настоящее время модуль filepicker, который может отличаться от основного модуля выбора файлов CMSMS, и этот модуль filepicker может игнорировать некоторые из этих параметров. </p>
<h3> Использование: </h3>
<ul>
  <li> name - <strong> обязательная </strong> строка - имя поля ввода. </li>
  <li> prefix - <em> (необязательно) </em> строка - префикс для имени поля ввода. </li>
  <li> value - <em> (необязательно) </em> строка - текущее значение для поля ввода. </li>
  <li> profile - <em> (необязательно) </em> строка - имя используемого профиля. Профиль должен существовать в выбранном модуле выбора файлов, в противном случае можно использовать профиль по умолчанию. </li>
  <li> top - <em> (необязательно) </em> строка - каталог относительно каталога загрузок. Переопределяет любое значение, уже указанное в профиле. </li>
  <li> type - <em> (необязательно) </em> строка - указание типа файла, который можно выбрать.
      <p> Возможные значения: image,audio,video,media,xml,document,archive,any </p>
  </li>
  <li> required - <em> (необязательно) </em> логическое значение - указывает, является ли поле ввода обязательным или нет. </li>
</ul>
<h3> Пример: </h3>
<p> Создайте поле выбора файлов, чтобы можно было выбирать изображения в каталоге images/apples. </p>
<pre> <code> {cms_filepicker prefix=$actionid name= rticle_image top=\'images/apples\' type=\'image\'} </code> </pre>';
$lang['help_function_thumbnail_url'] = '<h3> Для чего это нужно? </h3>
<p> Этот тег генерирует URL-адрес миниатюрного изображения, если указан файл этого изображения относительно каталога uploads в редакторе страницы. </p>
<p> Этот тег вернет пустую строку, если указанный файл не существует, эскиз не существует или есть проблемы с разрешениями. </p>
<h3> Использование: </h3>
<ul>
   <li> file - <strong> обязательно </strong> - имя файла и путь относительно каталога uploads. </li>
   <li> dir - <em> (необязательно) </em> - необязательный префикс каталога для добавления к имени файла. </li>
   <li> assign - <em> (необязательно) </em> - назначить вывод названной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
<pre> <code> &lt;img src=&quot;{thumbnail_url file=\'images/something.jpg\'}&quot; alt=&quot;something.jpg&quot; /&gt; </code> </pre>';
$lang['help_function_file_url'] = '<h3> Для чего это нужно? </h3>
<p> Этот тег генерирует URL-адрес файла в директории uploads установки CMSMS. </p>
<p> Этот тег вернет пустую строку, если указанный файл не существует или есть проблемы с разрешениями. </p>
<h3> Использование: </h3>
<ul>
   <li> file - <strong> обязательно </strong> - имя файла и путь относительно каталога uploads. </li>
   <li> dir - <em> (необязательно) </em> - необязательный префикс каталога для добавления к имени файла. </li>
   <li> assign - <em> (необязательно) </em> - назначить вывод названной переменной smarty. </li>
</ul>
<h3> Пример: </h3>
<pre> <code> &lt;a href=&quot;{file_url file=\'images/something.jpg\'}&quot;&gt;просмотреть файл&lt;/a&gt; </code> </pre>';
$lang['help_function_form_end'] = '<h3> Для чего это нужно? </h3>
<p> Этот тег создает закрывающий тег формы. </p>
<h3> Какие параметры он принимает? </p>
<ul>
   <li> assign - <em> (необязательно) </em> - присвоить результаты этого тега названной переменной smarty. </li>
</ul>
<h3> Использование: </h3>
<pre><code>{form_end}</code> </pre>
<h3> См. также: </h3>
<p> См. тег {form_start}, который является дополнением к этому тегу. </p>';
$lang['help_function_form_start'] = '<h3> Для чего это нужно? </h3>
  <p> Этот тег создает тег form для action модуля. Это полезно в шаблонах модулей и является частью разделения дизайна и логики, что лежит в основе CMSMS. </p>
  <p> Этот тег принимает множество параметров, которые могут определять тег form и изменять его стиль. </p>
<h3> Какие параметры он принимает? </h3>
<ul>
  <li> module - <em> (необязательная строка) </em>
    <p> Модуль, в котором обрабатываются данные формы. Если этот параметр не указан, то делается попытка определить текущий модуль. <p>
  </li>
  <li> action - <em> (необязательная строка) </em>
    <p> action модуля, который обрабатывает данные формы. Если не указано, &quot;по умолчанию&quot; предполагается defaultaction модуля, и &quot;defaultadmin&quot; для запроса из панели управления. </p>
  </li>
  <li> mid = <em> (необязательная строка) </em>
    <p> Идентификатор action модуля, который обрабатывает данные формы. Если не указано, значение рассчитывается автоматически. </p>
  </li>
  <li> returnid = <em> (необязательное целое число) </em>
    <p> Идентификатор страницы контента, на которую должны быть отправлены результаты обработки ​​форма. Если не указано, используется id текущей страницы. Для запросов в панели управления этот атрибут не требуется. </p>
  </li>
  <li> inline = <em> (необязательное целое число) </em>
    <p> Логическое значение, указывающее, что форма должна быть отправлена ​​встроенной (вывод обработки формы заменяет исходный тег) или нет (вывод обработки формы заменяет тег {content}). Этот параметр применим только к запросам со стороный внешнего интерфейса и по умолчанию равен false. </p>
  </li>
  <li> method = <em> (необязательная строка) </em>
    <p> Возможные значения для этого поля: GET и POST. Значение по умолчанию - POST. </p>
  </li>
  <li> url = <em> (необязательная строка) </em>
    <p> Позволяет указать атрибут action для тега формы. Это полезно для создания форм, которые не предназначены для  модуля. Требуется полный URL. </p>
  </li>
  <li> enctype = <em> (необязательная строка) </em>
    <p> Позволяет указать тип кодировки для тега формы. Значение по умолчанию для этого поля - multipart/form-data. </p>
  </li>
  <li> id = <em> (необязательная строка) </em>
    <p> Позволяет указать атрибут id для тега формы. </p>
  </li>
  <li> class = <em> (необязательная строка) </em>
    <p> Позволяет указать атрибут класса для тега формы. </p>
  </li>
  <li> extraparms = <em> (необязательный ассоциативный массив) </em>
    <p> Позволяет указать ассоциативный (ключ/значение) массив с дополнительными параметрами для тега формы.
  </li>
  <li> assign = <em> (необязательная строка) </em>
    <p> Назначает вывод тега указанной переменной smarty. </p>
  </li>
</ul>
<p> Вы также можете указать дополнительные атрибуты form, добавив к атрибуту префикс &quot;form-&quot;. т.е. </p>
<pre> <code> {form_start form-data-foo=&quot;bar&quot; form-novalidate=&quot;&quot;} </code> </pre>
<p> <strong> Примечание. </strong> Сокращенные атрибуты Smarty не допускаются. Каждый предоставленный атрибут должен иметь значение, даже если оно пустое. </p>
<h3> Использование: </h3>
<p> В шаблоне модуля следующий код будет генерировать тег формы для текущего действия. </p>
<pre><code>{form_start}</code> </pre>
<p> Этот код в шаблоне модуля будет генерировать тег формы для указанного действия. </p>
<pre> <code> {form_start action=myaction} </code> </pre>
<p> Этот код сгенерирует тег формы для указанного действия в названном модуле. </p>
<pre> <code> {form_start module=News action=default} </code> </pre>
<p> Этот код сгенерирует тег формы для того же действия, но установит идентификатор и класс. </p>
<pre> <code> {form_start id=&quot;myform&quot; class=&quot;form-inline&quot;} </code> </pre>
<p> Этот код сгенерирует тег формы для указанного URL и установит идентификатор и класс. </p>
<pre> <code> {form_start url =&quot;/products&quot; class = &quot;form-inline&quot;} </code> </pre>
<h3> См. также: </h3>
<p> См. тег {form_end}, который дополняет этот тег. </p>
<h3> Пример 1: </h3>
<p> Ниже приведен образец формы для использования в модуле. Эта гипотетическая форма будет подчиняться действию, которое сгенерировало форму, и позволяет пользователю указать целочисленное ограничение pagelimit. </p>
<pre> <code> {form_start}
&lt;select name=&quot;{$actionid}pagelimit&quot;&gt;
&lt;option value=&quot;10&quot; &gt;10&lt;/option&gt;
&lt;option value=&quot;25&quot; &gt;25&lt;/option&gt;
&lt;option value=&quot;50&quot; &gt;50&lt;/option&gt;
&lt;slect&gt;
&lt;input type=&quot;submit&quot; name=&quot;{$actionid}submit&quot; value=&quot;Submit&quot; /&gt;
{form_end} </code> </pre>
<h3> Пример 2: </h3>
<p> Ниже приведен образец формы для использования во внешнем интерфейсе веб-сайта. Эта гипотетическая форма собирает ограничение на количество страниц и отправляет его в модуль новостей. </p>
<pre> <code> {form_start method=&quot;GET&quot; class=&quot;form-inline&quot;}
&lt;select name=&quot;pagelimit&quot; & gt;
&lt;option value=&quot;10&quot; &gt; 10 &lt;/option&gt;
&lt;option value=&quot;25&quot; &gt; 25 &lt;/option&gt;
&lt;option value=&quot;50&quot; &gt; 50 &lt;/option&gt;
&lt;select&gt;
&lt;input type=&quot;submit&quot; name=&quot;submit&quot; value=&quot;Submit&quot;/&gt;
{form_end}
{$ pagelimit = 25}
{if isset ($smarty.get.pagelimit)} {$pagelimit=$smarty.get.pagelimit}{/if}
{News pagelimit=$pagelimit} </code> </pre>';
$lang['function'] = 'Функции могут выполнять задачу или запрашивать базу данных и обычно выводят данные в шаблон. Их можно вызвать как {tagname [attribute = value ...]}';
$lang['modifier'] = 'Модификаторы принимают вывод переменной smarty в качестве параметра и изменяют его. Они вызываются так: {$variable|modifier[: arg: ...]}';
$lang['postfilter'] = 'Постфильтры вызываются smarty автоматически после компиляции каждого шаблона. Их нельзя вызвать вручную.';
$lang['prefilter'] = 'Предварительные фильтры вызываются smarty автоматически перед компиляцией каждого шаблона. Их нельзя вызвать вручную.';
$lang['tag_about'] = 'Отображение истории и информации об авторе для этого плагина, если доступно';
$lang['tag_adminplugin'] = 'Указывает, что тег доступен только в интерфейсе администратора и обычно используется в шаблонах модулей.';
$lang['tag_cachable'] = 'Указывает, можно ли кэшировать вывод плагина (если включено умное кэширование). Плагины администратора и модификаторы не кэшируются.';
$lang['tag_help'] = 'Показать справку (если таковая существует) для этого тега';
$lang['tag_name'] = 'Это имя тега';
$lang['tag_type'] = 'Тип тега (функция, модификатор или предварительный или пост-фильтр)';
$lang['title_admin'] = 'Этот плагин доступен только из административной панели CMSMS.';
$lang['title_notadmin'] = 'Этот плагин можно использовать как в консоли администратора, так и на веб-сайте.';
$lang['title_cachable'] = 'Этот плагин кэшируемый';
$lang['title_notcachable'] = 'Этот плагин не кэшируется';
$lang['viewabout'] = 'Показать историю и информацию об авторе для этого модуля';
$lang['viewhelp'] = 'Показать справку для этого модуля';
$lang['ga'] = 'GA1.2.1491380592.1611499782';
?>