# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2021 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENCE.TXT
#

import os


CL_SELECTOR_BIN = '/usr/sbin/cloudlinux-selector'
PERSISTENT_DIR = '/var/lve/wizard/'
MODULES_LOGS_DIR = '/var/log/cloudlinux/wizard/'
MODULES_STATUS_FILE = os.path.join(PERSISTENT_DIR, 'modules-statuses.json')
FILE_MARKER_PATH = os.path.join(PERSISTENT_DIR, 'done.flag')
MODULES_STATUS_FILE_LOCK = MODULES_STATUS_FILE + '.lock'

MAIN_LOG_PATH = os.path.join(MODULES_LOGS_DIR, 'wizard.log')
CRASH_LOG_PATH = os.path.join(MODULES_LOGS_DIR, 'crash.log')


class ModuleStatus:
    """
    pending: in queue for installation
    installing: currently installing
    installed: installation of module (package) finished
    failed: if module was aborted during installation
    auto-skipped: if automatic installation of module (package) is impossible
    """
    CANCELLED = 'cancelled'
    FAILED = 'failed'
    INSTALLED = 'installed'
    INSTALLING = 'installing'
    PENDING = 'pending'
    AUTO_SKIPPED = 'auto-skipped'


class WizardStatus:
    """
    idle: never executed before
    in_progress: currently working
    failed: installation of some module failed
    crashed: something really weird happened
    done: installation finished
    """
    IDLE = 'idle'
    IN_PROGRESS = 'in_progress'
    FAILED = 'failed'
    CRASHED = 'crashed'
    DONE = 'done'
