#!/opt/cloudlinux/venv/bin/python3 -bb
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2021 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENCE.TXT
#

from clcommon import FormattedException


class InstallationFailedException(Exception):
    """
    Exception that should be raised to signal
    that some bad error happened during installation
    and user should review log files
    """
    pass


class PackageMissingError(FormattedException):
    """
    Exception that should be raised when we are missing
    some required package for wizard work
    """
    def __init__(self, package):
        super().__init__({
            'message': "This module requires '%(package)s' package, but it "
                       "is missing in system. Please install it and try again.",
            'context': {'package': package}
        })


class CancelModuleException(FormattedException):
    """
    Error that is raised when it is not permitted to cancel module
    installation, e.g. module is installing at the moment.
    """
    def __init__(self, module, status):
        super().__init__({
            'message': 'Module "%(module)s" can\'t be cancelled as it is in status "%(status)s".',
            'context': {'module': module, 'status': status}
        })


class UserInterventionNeededError(Exception):
    """
    Exception that is raised when it is impossible to install module
    (package) automatically
    """
    pass
