#!/opt/cloudlinux/venv/bin/python3 -bb
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2021 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENCE.TXT
#

from clcommon import FormattedException


class BaseConfigError(FormattedException):
    pass


class MalformedConfigError(BaseConfigError):
    """
    Error that is raised when config is
    malformed and cannot be read.
    """
    def __init__(self, config_path):
        super().__init__({
            'message': 'Config file "%(config_path)s" is corrupted, '
                       'try to run wizard again or contact CloudLinux support.',
            'context': {'config_path': config_path}
        })


class NoSuchModule(BaseConfigError):
    """
    Error that is raised when we are trying to get state
    or options for module from config, but it is absent
    """
    def __init__(self, module):
        super().__init__({
            'message': 'No such module "%(module)s" in config.',
            'context': {'module': module}
        })


class UnableAcquireLockError(BaseConfigError):
    def __init__(self, error_message):
        super().__init__({
            'message': 'Unable to acquire lock for config due to error: "%(error)s".',
            'context': {'error': error_message}
        })
