#!/opt/cloudlinux/venv/bin/python3 -bb
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2021 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENCE.TXT
#

import sys

from lve_utils.sentry import init_lve_utils_sentry_client
from clcommon.cpapi import Feature, is_panel_feature_supported
from clwizard.wizard import CloudlinuxWizard


def main(argv):
    """
    Main run function
    """
    if not is_panel_feature_supported(Feature.WIZARD):
        print('CloudLinux Wizard is not supported in current environment. '
              'Check your list of supported features if using integration scripts')
        return

    init_lve_utils_sentry_client('wizard')
    clw = CloudlinuxWizard()
    return clw.run(argv)


if __name__ == "__main__":
    sys.exit(main(sys.argv[1:]))
