# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from docopt import docopt
from docopt import DocoptExit
from schema import Schema, SchemaError, Or, Use


def parse_cloudlinux_summary_opts(argv):
    """
    Parse arguments for cloudlinux-summary command
    :param argv: sys.argv
    :return cortege: (error_flag, s_message)
    """
    # program name
    prog_name = "cloudlinux-summary"
    docstring = f"""Utility to get Cloudlinux usage statistics

Usage:
   {prog_name} [--json] [--send] [--force-collect] [--lve-id <int>] [--async]
   {prog_name} status [--json]
   {prog_name} rpm-packages [--json] [--lve-id <int>] [--send] [--force-collect]
   {prog_name} get-remote [--json] [--lve-id <int>]
   {prog_name} enable [--json] [--lve-id <int>]
   {prog_name} disable [--json] [--lve-id <int>]
   {prog_name} enable-rpm [--json]
   {prog_name} disable-rpm [--json]
   {prog_name} (-h | --help)

Options:
    --json                              Return data in JSON format.
    --send                              Send summary to the CloudLinux server
    --force-collect                     Ignore global settings.json when collecting statistics
    --lve-id <int>                      LVE for summary script. For internal use only.
    --async                             Start background process collecting statistics, return immediately
    -h, --help                          Show this help message and exit
"""
    try:
        args = docopt(docstring, argv)
    except DocoptExit:
        s_error_string = 'ERROR: Invalid parameter passed'
        return False, s_error_string
    s = Schema({
        "get-remote": bool,
        "rpm-packages": bool,
        "status": bool,
        "enable": bool,
        "disable": bool,
        "enable-rpm": bool,
        "disable-rpm": bool,
        "--json": bool,
        "--send": bool,
        "--force-collect": bool,
        "--help": bool,
        "--lve-id": Or(Use(int), None),
        "--async": bool,
    })

    try:
        args = s.validate(args)
        status = True
    except SchemaError as e:
        args = str(e)
        status = False
    return status, args
