#!/opt/cloudlinux/venv/bin/python3 -bb
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
import os

from clcommon.utils import get_file_lines

PACKAGES_FILES_PATH = '/usr/share/cloudlinux'
SENSITIVE_FIELDS = [
    'password',
    'secret',
    'passwd',
    'authorization',
    'api_key',
    'apikey',
    'sentry_dsn',
    'access_token',
    'email',
    'token',
    'pass',
]


def get_pkg_version(package):
    """
    Get package version using rpm
    or None if any error or package absent.
    :type package: str
    :rtype: str|None
    """
    # First we try to read package version from file
    try:
        file_lines = get_file_lines(os.path.join(PACKAGES_FILES_PATH, package))
        if file_lines:
            return file_lines[0].strip().split(".el", 1)[0]
    except (OSError, IOError, IndexError):
        return None
