#!/opt/cloudlinux/venv/bin/python3 -bb
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
"""Module for all sentry processors related code"""

from raven.processors import SanitizePasswordsProcessor
from clsentry.utils import SENSITIVE_FIELDS


class UserlandSanitize(SanitizePasswordsProcessor):
    """
    Beside from default SanitizePasswordsProcessor algorithm, also
    search key-values in query-like strings.
    Also sanitize some additional fields.
    """
    FIELDS = frozenset(SENSITIVE_FIELDS)

    def sanitize(self, item, value):
        new_value = super().sanitize(item, value)
        if new_value == value and isinstance(value, str) and '=' in value:
            new_value = self._sanitize_keyvals(value, '&')
        return new_value
