# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import print_function
from __future__ import division
from __future__ import absolute_import
import glob
import os


def is_clpassenger_active():
    """
    Detect if passenger active on server. Detects:
     - CL passenger ea-apache24-mod-alt-passenger/alt-mod-passenger
     - CL EA4 passenger ea-ruby24-mod_passenger
     - CL EA4 passenger ea-ruby27-mod_passenger
     - CentOS passenger
    :return bool: True/False - passenger found/not found
    """
    # CentOS passenger binary
    orig_passenger_file = "/usr/bin/passenger"
    # List of CL passenger dirs
    passenger_dirs = glob.glob('/opt/passenger*')
    # EA4-ruby24 passenger
    is_ea4_ruby24_passenger = os.path.isdir('/opt/cpanel/ea-ruby24/root/usr/share/passenger')
    # EA4-ruby27 passenger
    is_ea4_ruby27_passenger = os.path.isdir('/opt/cpanel/ea-ruby27/root/usr/share/passenger')

    if os.path.isfile(orig_passenger_file) or passenger_dirs or is_ea4_ruby24_passenger or is_ea4_ruby27_passenger:
        return True
    return False
