# coding: utf-8

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

from __future__ import absolute_import
from __future__ import print_function
from __future__ import division
from clselect.baseclselect.selector_manager import BaseSelectorManager
from .config import NodeConfig
from .pkgmanager import PkgManager

# This is the lowest version supported by NodeJS selector.
# Currently, it's not used directly in NodeManager and exists here only for
# self-documentation reasons
API_1 = 1


class NodeManager(BaseSelectorManager):
    """Responsible for actual NodeJS selector high-level API"""

    def __init__(self, cfg=None, pkg=None):
        pkg = pkg or PkgManager()
        cfg = cfg or NodeConfig(pkg)                      #pylint: disable=E0110
        super(NodeManager, self).__init__(cfg, pkg)
