<?php
/**
 * SslApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * orchd
 *
 * orchd API docs
 *
 * The version of the OpenAPI document: 12.7.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.14.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * SslApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SslApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getWebsiteDomainSslCert' => [
            'application/json',
        ],
        'getWebsiteMailDomainSslCert' => [
            'application/json',
        ],
        'setWebsiteDomainForceSsl' => [
            'application/json',
        ],
        'uploadWebsiteDomainSslCert' => [
            'application/json',
        ],
        'uploadWebsiteMailDomainSslCert' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getWebsiteDomainSslCert
     *
     * Returns the SSL for this website domain
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DomainSslCertWithData
     */
    public function getWebsiteDomainSslCert($domain_id, string $contentType = self::contentTypes['getWebsiteDomainSslCert'][0])
    {
        list($response) = $this->getWebsiteDomainSslCertWithHttpInfo($domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteDomainSslCertWithHttpInfo
     *
     * Returns the SSL for this website domain
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DomainSslCertWithData, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteDomainSslCertWithHttpInfo($domain_id, string $contentType = self::contentTypes['getWebsiteDomainSslCert'][0])
    {
        $request = $this->getWebsiteDomainSslCertRequest($domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\DomainSslCertWithData',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\DomainSslCertWithData',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DomainSslCertWithData',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWebsiteDomainSslCertAsync
     *
     * Returns the SSL for this website domain
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainSslCertAsync($domain_id, string $contentType = self::contentTypes['getWebsiteDomainSslCert'][0])
    {
        return $this->getWebsiteDomainSslCertAsyncWithHttpInfo($domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteDomainSslCertAsyncWithHttpInfo
     *
     * Returns the SSL for this website domain
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteDomainSslCertAsyncWithHttpInfo($domain_id, string $contentType = self::contentTypes['getWebsiteDomainSslCert'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DomainSslCertWithData';
        $request = $this->getWebsiteDomainSslCertRequest($domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteDomainSslCert'
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteDomainSslCertRequest($domain_id, string $contentType = self::contentTypes['getWebsiteDomainSslCert'][0])
    {

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getWebsiteDomainSslCert'
            );
        }


        $resourcePath = '/v2/domains/{domain_id}/ssl';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWebsiteMailDomainSslCert
     *
     * Returns the SSL for this website domain with the mail.prefix
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DomainSslCertWithData
     */
    public function getWebsiteMailDomainSslCert($domain_id, string $contentType = self::contentTypes['getWebsiteMailDomainSslCert'][0])
    {
        list($response) = $this->getWebsiteMailDomainSslCertWithHttpInfo($domain_id, $contentType);
        return $response;
    }

    /**
     * Operation getWebsiteMailDomainSslCertWithHttpInfo
     *
     * Returns the SSL for this website domain with the mail.prefix
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DomainSslCertWithData, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWebsiteMailDomainSslCertWithHttpInfo($domain_id, string $contentType = self::contentTypes['getWebsiteMailDomainSslCert'][0])
    {
        $request = $this->getWebsiteMailDomainSslCertRequest($domain_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\DomainSslCertWithData',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\DomainSslCertWithData',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DomainSslCertWithData',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getWebsiteMailDomainSslCertAsync
     *
     * Returns the SSL for this website domain with the mail.prefix
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteMailDomainSslCertAsync($domain_id, string $contentType = self::contentTypes['getWebsiteMailDomainSslCert'][0])
    {
        return $this->getWebsiteMailDomainSslCertAsyncWithHttpInfo($domain_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWebsiteMailDomainSslCertAsyncWithHttpInfo
     *
     * Returns the SSL for this website domain with the mail.prefix
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWebsiteMailDomainSslCertAsyncWithHttpInfo($domain_id, string $contentType = self::contentTypes['getWebsiteMailDomainSslCert'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DomainSslCertWithData';
        $request = $this->getWebsiteMailDomainSslCertRequest($domain_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWebsiteMailDomainSslCert'
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWebsiteMailDomainSslCertRequest($domain_id, string $contentType = self::contentTypes['getWebsiteMailDomainSslCert'][0])
    {

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling getWebsiteMailDomainSslCert'
            );
        }


        $resourcePath = '/v2/domains/{domain_id}/mail_ssl';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setWebsiteDomainForceSsl
     *
     * Set \&quot;force ssl\&quot; status for domain mapping
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $body Boolean \&quot;force ssl\&quot; setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWebsiteDomainForceSsl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function setWebsiteDomainForceSsl($domain_id, $body, string $contentType = self::contentTypes['setWebsiteDomainForceSsl'][0])
    {
        $this->setWebsiteDomainForceSslWithHttpInfo($domain_id, $body, $contentType);
    }

    /**
     * Operation setWebsiteDomainForceSslWithHttpInfo
     *
     * Set \&quot;force ssl\&quot; status for domain mapping
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $body Boolean \&quot;force ssl\&quot; setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWebsiteDomainForceSsl'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function setWebsiteDomainForceSslWithHttpInfo($domain_id, $body, string $contentType = self::contentTypes['setWebsiteDomainForceSsl'][0])
    {
        $request = $this->setWebsiteDomainForceSslRequest($domain_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
        

            throw $e;
        }
    }

    /**
     * Operation setWebsiteDomainForceSslAsync
     *
     * Set \&quot;force ssl\&quot; status for domain mapping
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $body Boolean \&quot;force ssl\&quot; setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWebsiteDomainForceSsl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWebsiteDomainForceSslAsync($domain_id, $body, string $contentType = self::contentTypes['setWebsiteDomainForceSsl'][0])
    {
        return $this->setWebsiteDomainForceSslAsyncWithHttpInfo($domain_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setWebsiteDomainForceSslAsyncWithHttpInfo
     *
     * Set \&quot;force ssl\&quot; status for domain mapping
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $body Boolean \&quot;force ssl\&quot; setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWebsiteDomainForceSsl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setWebsiteDomainForceSslAsyncWithHttpInfo($domain_id, $body, string $contentType = self::contentTypes['setWebsiteDomainForceSsl'][0])
    {
        $returnType = '';
        $request = $this->setWebsiteDomainForceSslRequest($domain_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setWebsiteDomainForceSsl'
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  bool $body Boolean \&quot;force ssl\&quot; setting (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setWebsiteDomainForceSsl'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setWebsiteDomainForceSslRequest($domain_id, $body, string $contentType = self::contentTypes['setWebsiteDomainForceSsl'][0])
    {

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling setWebsiteDomainForceSsl'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling setWebsiteDomainForceSsl'
            );
        }


        $resourcePath = '/v2/domains/{domain_id}/ssl/force_ssl';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadWebsiteDomainSslCert
     *
     * Upload custom ssl certificate, key and optional fullchain for a given website
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewSslCert
     */
    public function uploadWebsiteDomainSslCert($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteDomainSslCert'][0])
    {
        list($response) = $this->uploadWebsiteDomainSslCertWithHttpInfo($domain_id, $ssl_cert, $contentType);
        return $response;
    }

    /**
     * Operation uploadWebsiteDomainSslCertWithHttpInfo
     *
     * Upload custom ssl certificate, key and optional fullchain for a given website
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewSslCert, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadWebsiteDomainSslCertWithHttpInfo($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteDomainSslCert'][0])
    {
        $request = $this->uploadWebsiteDomainSslCertRequest($domain_id, $ssl_cert, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewSslCert',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewSslCert',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewSslCert',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadWebsiteDomainSslCertAsync
     *
     * Upload custom ssl certificate, key and optional fullchain for a given website
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadWebsiteDomainSslCertAsync($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteDomainSslCert'][0])
    {
        return $this->uploadWebsiteDomainSslCertAsyncWithHttpInfo($domain_id, $ssl_cert, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadWebsiteDomainSslCertAsyncWithHttpInfo
     *
     * Upload custom ssl certificate, key and optional fullchain for a given website
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadWebsiteDomainSslCertAsyncWithHttpInfo($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteDomainSslCert'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewSslCert';
        $request = $this->uploadWebsiteDomainSslCertRequest($domain_id, $ssl_cert, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadWebsiteDomainSslCert'
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadWebsiteDomainSslCertRequest($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteDomainSslCert'][0])
    {

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling uploadWebsiteDomainSslCert'
            );
        }

        // verify the required parameter 'ssl_cert' is set
        if ($ssl_cert === null || (is_array($ssl_cert) && count($ssl_cert) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $ssl_cert when calling uploadWebsiteDomainSslCert'
            );
        }


        $resourcePath = '/v2/domains/{domain_id}/ssl';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($ssl_cert)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($ssl_cert));
            } else {
                $httpBody = $ssl_cert;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation uploadWebsiteMailDomainSslCert
     *
     * Upload SSL for mail.customerdomain.
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\NewSslCert
     */
    public function uploadWebsiteMailDomainSslCert($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteMailDomainSslCert'][0])
    {
        list($response) = $this->uploadWebsiteMailDomainSslCertWithHttpInfo($domain_id, $ssl_cert, $contentType);
        return $response;
    }

    /**
     * Operation uploadWebsiteMailDomainSslCertWithHttpInfo
     *
     * Upload SSL for mail.customerdomain.
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\NewSslCert, HTTP status code, HTTP response headers (array of strings)
     */
    public function uploadWebsiteMailDomainSslCertWithHttpInfo($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteMailDomainSslCert'][0])
    {
        $request = $this->uploadWebsiteMailDomainSslCertRequest($domain_id, $ssl_cert, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 201:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\NewSslCert',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\NewSslCert',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\NewSslCert',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation uploadWebsiteMailDomainSslCertAsync
     *
     * Upload SSL for mail.customerdomain.
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadWebsiteMailDomainSslCertAsync($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteMailDomainSslCert'][0])
    {
        return $this->uploadWebsiteMailDomainSslCertAsyncWithHttpInfo($domain_id, $ssl_cert, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation uploadWebsiteMailDomainSslCertAsyncWithHttpInfo
     *
     * Upload SSL for mail.customerdomain.
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadWebsiteMailDomainSslCertAsyncWithHttpInfo($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteMailDomainSslCert'][0])
    {
        $returnType = '\OpenAPI\Client\Model\NewSslCert';
        $request = $this->uploadWebsiteMailDomainSslCertRequest($domain_id, $ssl_cert, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'uploadWebsiteMailDomainSslCert'
     *
     * @param  string $domain_id The id of the domain. (required)
     * @param  \OpenAPI\Client\Model\SslCert $ssl_cert Cert, private key and optional fullchain. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['uploadWebsiteMailDomainSslCert'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function uploadWebsiteMailDomainSslCertRequest($domain_id, $ssl_cert, string $contentType = self::contentTypes['uploadWebsiteMailDomainSslCert'][0])
    {

        // verify the required parameter 'domain_id' is set
        if ($domain_id === null || (is_array($domain_id) && count($domain_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $domain_id when calling uploadWebsiteMailDomainSslCert'
            );
        }

        // verify the required parameter 'ssl_cert' is set
        if ($ssl_cert === null || (is_array($ssl_cert) && count($ssl_cert) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $ssl_cert when calling uploadWebsiteMailDomainSslCert'
            );
        }


        $resourcePath = '/v2/domains/{domain_id}/mail_ssl';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($domain_id !== null) {
            $resourcePath = str_replace(
                '{' . 'domain_id' . '}',
                ObjectSerializer::toPathValue($domain_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($ssl_cert)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($ssl_cert));
            } else {
                $httpBody = $ssl_cert;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
