<?php


namespace Alipay\EasySDK\Kernel\Util;


use Alipay\EasySDK\Kernel\AlipayConstants;

class PageUtil
{
    public function buildForm($actionUrl,$parameters){
        $sHtml = "<form id='alipaysubmit' name='alipaysubmit' action='" . $actionUrl . "?charset=" . trim(AlipayConstants::DEFAULT_CHARSET) . "' method='POST'>";
        while (list ($key, $val) = $this->fun_adm_each($parameters)) {
            if (false === $this->checkEmpty($val)) {
                $val = str_replace("'", "&apos;", $val);
                //$val = str_replace("\"","&quot;",$val);
                $sHtml .= "<input type='hidden' name='" . $key . "' value='" . $val . "'/>";
            }
        }

        //submit按钮控件请不要含有name属性
        $sHtml = $sHtml . "<input type='submit' value='ok' style='display:none;'></form>";

        $sHtml = $sHtml . "<script>document.forms['alipaysubmit'].submit();</script>";

        return $sHtml;
    }

    protected function fun_adm_each(&$array)
    {
        $res = array();
        $key = key($array);
        if ($key !== null) {
            next($array);
            $res[1] = $res['value'] = $array[$key];
            $res[0] = $res['key'] = $key;
        } else {
            $res = false;
        }
        return $res;
    }

    /**
     * 校验$value是否非空
     *  if not set ,return true;
     *    if is null , return true;
     **/
    protected function checkEmpty($value)
    {
        if (!isset($value))
            return true;
        if ($value === null)
            return true;
        if (trim($value) === "")
            return true;

        return false;
    }

}