#!/usr/bin/env php

<?php

/*
 * To update disposable email providers from the command line run:
 * $ ./update-disposable-email-providers.php
 */

$disposableEmailProvidersLocation = 'https://raw.githubusercontent.com/ivolo/disposable-email-domains/master/index.json';

$disposableEmailProvidersJson = file_get_contents($disposableEmailProvidersLocation);

if (!is_string($disposableEmailProvidersJson)) { die('Failed to fetch providers'); }

$disposableEmailProviders = json_decode($disposableEmailProvidersJson, true);

if (!is_array($disposableEmailProviders)) { die('Unable to decode JSON'); }

$exportedArray = var_export($disposableEmailProviders, true);

$phpFileTemplate = <<<TEMPLATE
<?php

/**
 * This data is autogenerated. 
 *
 * @see https://github.com/ivolo/disposable-email-domains
 */
 
 return {$exportedArray};
 
TEMPLATE;

$writeToFile = file_put_contents('../src/data/disposable-email-providers.php', $phpFileTemplate);

if (!$writeToFile) { die('Failed to write to file'); }

echo "Successfully Fetched Disposable Email Providers";
exit();