<?php
/**
 *
 * @copyright 2008 - https://www.clicshopping.org
 * @Brand : ClicShoppingAI(TM) at Inpi all right Reserved
 * @Licence GPL 2 & MIT
 * @Info : https://www.clicshopping.org/forum/trademark/
 *
 */

namespace ClicShopping\Apps\Catalog\Products\Sites\ClicShoppingAdmin\Pages\Home\Actions;

use ClicShopping\OM\Registry;

/**
 * Class Preview
 *
 * This action class handles the preview functionality in the admin interface.
 * It sets up the preview page and loads necessary definitions.
 */
class Preview extends \ClicShopping\OM\PagesActionsAbstract
{
  /**
   * Execute the preview action.
   *
   * This method sets the page file to 'preview.php', assigns the action name,
   * and loads language definitions for the Products app.
   */
  public function execute()
  {
    $CLICSHOPPING_Products = Registry::get('Products');

    $this->page->setFile('preview.php');
    $this->page->data['action'] = 'Preview';

    $CLICSHOPPING_Products->loadDefinitions('Sites/ClicShoppingAdmin/main');
  }
}