#!/opt/cloudlinux/venv/bin/python3 -bb
# coding=utf-8
#
# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
"""
Write your additional event handlers here.

Example:

@reseller_limits_disabled_post.register
def set_invisible_icon(*a, **k):
    print(a, k, 'reseller_limits_disabled_post')

Where reseller_limits_disabled_post is an event object
and set_invisible_icon is your custom handler

Instead of using decorator, you can manually write
reseller_limits_disabled_post.register(callable_handler).
"""

# pylint: disable=import-outside-toplevel

from clcommon.utils import run_command

from .events import (
    reseller_limits_disabled_post,
    reseller_limits_enabled_post
)


@reseller_limits_disabled_post.register
def hide_lvemanager_link_for_reseller(reseller):
    from clconfig.ui_config_lib import DYNAMIC_UI_CTL_CMD
    run_command([DYNAMIC_UI_CTL_CMD, '--hide-for-reseller', reseller])


@reseller_limits_enabled_post.register
def show_lvemanager_link_for_reseller(reseller):
    from clconfig.ui_config_lib import DYNAMIC_UI_CTL_CMD
    run_command([DYNAMIC_UI_CTL_CMD, '--show-for-reseller', reseller])
