# coding: utf-8

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2019 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT

import platform
from datetime import timedelta


def get_linux_kernel_release():
    """
    Get linux kernel release version
    :return: kernel release version
    :rtype: str
    """

    return platform.release()


def get_uptime():
    """
    Get server uptime
    :return str: human readable value of server uptime
    """

    with open('/proc/uptime', 'r', encoding='utf-8') as proc_uptime:
        uptime_sec = float(proc_uptime.readline().split()[0])
        uptime_object = timedelta(seconds=uptime_sec)
        days = uptime_object.days
        hours = uptime_object.seconds // 3600

    if days > 0:
        result = {
            'message': '%(days)s days',
            'context': {
                'days': days,
            }
        }
    elif hours > 0:
        result = {
            'message': '%(hours)s hours',
            'context': {
                'hours': hours,
            }
        }
    else:
        result = {
            'message': 'less then 1 hour',
            'context': {}
        }
    return result
