# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2024 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# https://cloudlinux.com/docs/LICENCE.TXT
#
import subprocess
from pathlib import Path

from clcommon.lib.consts import CL_EDITION_FILE_FOR_USERS


def remove_cl_edition_file():
    """
    Remove the file that contains the CloudLinux edition
    for end-user access.
    See CLOS-2411 for more info.
    """
    Path(CL_EDITION_FILE_FOR_USERS).unlink(missing_ok=True)


def update_cl_edition_file():
    """
    Populate edition cache again with new edition.
    """
    with subprocess.Popen(
        ['/usr/bin/cldetect', '--detect-edition'],
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
    ) as proc:
        stdout, _ = proc.communicate()
        if proc.returncode != 0:
            return

    with open(CL_EDITION_FILE_FOR_USERS, 'wb') as f:
        f.write(stdout)
