# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# https://cloudlinux.com/docs/LICENCE.TXT
#
import logging

from clconfigure import run, task


@task("Disabling autotracing")
def disable_autotracing():
    result = run(['/usr/sbin/cloudlinux-autotracing', 'disable', '--all'])
    if result.exitcode != 0:
        logging.warning('Unable to disable autotracing. stdout: %s, stderr: %s',
                        result.stdout, result.stderr)


@task("Reconfiguration of Shared Pro exclusive features")
def trigger_manage_clplus():
    result = run(['/usr/share/cloudlinux/cl_plus/manage_clplus'])
    if result.exitcode != 0:
        logging.warning('Unable to reconfigure Shared Pro-only features. stdout: %s, stderr: %s',
                        result.stdout, result.stderr)
