# Overview

This is a short overview of what is going on in this tool.

## Idea

cloudlinux-reconfigure automatically updates system configuration according to
"specification" of different editions. Right now "specifications" are defined
in `spec/` package as python scripts with the only method `provision(...)`.


There are some limitations that developers should stick to:
- `provision` method *must* be able to configure server no matter what edition was 
  installed previously. This means, e.g. if we make transition between `Admin` and `Solo`
  the latter is responsible for erasing `cloudlinux-admin-meta` package before installation
  of the `cloudlinux-solo-meta`



## Future

Here are couple notes for the future

### Provisioning responsibilities
Maybe we can add additional `deprovision` method which will be responsible for the 
cleanup of the edition that we are leaving. This will shift the responsibility e.g.
of removing meta packages to the module which performed provisioning previously.

On the other hand, it will increase migration time.

### Project structure
We can consider grouping actions not by the `edition`, but by the `project`, e.g.
```
spec/
    accelerate_wp/
        provision(edition, ...)
        deprovision(edition, ...)
    cagefs/
        provision(edition, ...)
        deprovision(edition, ...)
    lve-utils/
        provision(edition, ...)
        deprovision(edition, ...)
```

### Ansible?
We can use ansible playbooks instead of python to describe provisioning.
User-friendly playbooks with wide possibilities and also options like dry-run
which allow us to draw nice-looking progress for user.
