# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#

import os


class ClSec:
    class NoRootException(Exception):
        def __init__(self):
            Exception.__init__(self, 'You need to be root to perform this command.')

    def is_root():
        if os.geteuid() != 0:
            return False
        return True
    is_root = staticmethod(is_root)

    def check_root():
        if not (ClSec.is_root()):
            raise ClSec.NoRootException()
    check_root = staticmethod(check_root)

