# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#

from .clfunc import escape_formatting_chars


class FormattedException(Exception):

    def __init__(self, exc_message):
        if isinstance(exc_message, dict):
            self.message = escape_formatting_chars(exc_message["message"])
            self.context = exc_message.get("context", {})
            self.details = exc_message.get("details")
            message = self.message % self.context
        elif isinstance(exc_message, FormattedException):
            self.message = escape_formatting_chars(exc_message.message)
            self.context = exc_message.context
            self.details = exc_message.details
            message = self.message % self.context
        else:
            self.message = escape_formatting_chars(exc_message)
            self.context = {}
            self.details = None
            message = exc_message
        Exception.__init__(self, message)

    def __str__(self):
        return self.message % self.context
