#!/usr/bin/python
# coding=utf-8
import os

__author__ = "Aleksandr Shyshatsky"


def lvectl_custompanel_script():
    """
    Retrives custom panel script for lvectl from CL config file
    :return: Script full path or None if script filename not find in config
    """
    config_param_name = 'CUSTOM_GETPACKAGE_SCRIPT'
    try:
        # Try to determine custom script name
        if os.path.exists(CLSYSCONFIG):
            with open(CLSYSCONFIG, 'r', encoding='utf-8') as f:
                file_lines = f.readlines()
            for line in file_lines:
                line = line.strip()
                if line.startswith(config_param_name):
                    line_parts = line.split('=')
                    if len(line_parts) == 2 and line_parts[0].strip() == config_param_name:
                        script_name = line_parts[1].strip()
                        if os.path.exists(script_name):
                            return script_name
    except (OSError, IOError, IndexError):
        # We are ignoring all errors, but script name not found in this case
        pass
    # Script name not found or error
    return None


CLSYSCONFIG = '/etc/sysconfig/cloudlinux'