# -*- coding: utf-8 -*-

# Copyright © Cloud Linux GmbH & Cloud Linux Software, Inc 2010-2018 All Rights Reserved
#
# Licensed under CLOUD LINUX LICENSE AGREEMENT
# http://cloudlinux.com/docs/LICENSE.TXT
#

import os

CPANEL_CONFIG_PATH = "/var/cpanel/cpanel.config"

def get_param(path, param):
    """
    Get param from config file
    :param path: Path to config file
    :type path: str
    :param param: Key for param in config file
    :type param: str
    """
    try:
        with open(path, encoding="utf-8") as f:
            data = f.readlines()
    except (OSError, IOError):
        return False
    for line in data:
        if line.startswith(f"{param}="):
            return (line.strip().split("="))[1]
    return None


def replace_param(path, param, value):
    """
    Replaces config file with path to config file with line param=value
    :param path: Path to config file
    :type path: str
    :param param: Key for param in config file
    :type key: str
    :param value: Value for param in config file
    :type value: str
    """
    new_line = f'{param}={value}\n'
    if not os.path.exists(path):
        # config file is absent
        with open(path, 'w', encoding='utf-8') as f:
            f.write(new_line)
        return
    # config file present
    with open(path, encoding='utf-8') as f:
        data = f.readlines()
    for i, line in enumerate(data):
        if line.startswith(f'{param}='):
            data[i] = new_line
            with open(path, 'w', encoding='utf-8') as f:
                f.write(''.join(data))
            return
    # add new line with given param if it wasn't in original config
    with open(path, 'a', encoding='utf-8') as f:
        f.write(new_line)
